/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.crunch.DoFn;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.ReadableData;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.types.PType;
import org.apache.crunch.util.DelegatingReadableData;

public class BaseDoCollection<S>
extends PCollectionImpl<S> {
    private final PCollectionImpl<Object> parent;
    protected final DoFn<Object, S> fn;
    protected final PType<S> ptype;

    protected <T> BaseDoCollection(String name, PCollectionImpl<T> parent, DoFn<T, S> fn, PType<S> ptype, ParallelDoOptions options) {
        super(name, parent.getPipeline(), options);
        this.parent = parent;
        this.fn = fn;
        this.ptype = ptype;
    }

    @Override
    protected long getSizeInternal() {
        return (long)(this.fn.scaleFactor() * (float)this.parent.getSize());
    }

    @Override
    protected ReadableData<S> getReadableDataInternal() {
        if (this.getOnlyParent() instanceof BaseGroupedTable) {
            return this.materializedData();
        }
        return new DelegatingReadableData<Object, S>(this.getOnlyParent().asReadable(false), this.fn);
    }

    @Override
    public PType<S> getPType() {
        return this.ptype;
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.of(this.parent);
    }

    @Override
    public long getLastModifiedAt() {
        return this.parent.getLastModifiedAt();
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitDoCollection(this);
    }
}

