/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.ReadableData;
import org.apache.crunch.Source;
import org.apache.crunch.impl.dist.DistributedPipeline;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.types.PType;

public class BaseInputCollection<S>
extends PCollectionImpl<S> {
    protected final Source<S> source;

    public BaseInputCollection(Source<S> source, DistributedPipeline pipeline) {
        super(source.toString(), pipeline);
        this.source = source;
    }

    @Override
    protected ReadableData<S> getReadableDataInternal() {
        if (this.source instanceof ReadableSource) {
            return ((ReadableSource)this.source).asReadable();
        }
        return this.materializedData();
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitInputCollection(this);
    }

    @Override
    public PType<S> getPType() {
        return this.source.getType();
    }

    public Source<S> getSource() {
        return this.source;
    }

    @Override
    protected long getSizeInternal() {
        long sz = this.source.getSize(this.pipeline.getConfiguration());
        if (sz < 0L) {
            throw new IllegalStateException("Input source " + this.source + " does not exist!");
        }
        return sz;
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.of();
    }

    @Override
    public long getLastModifiedAt() {
        return this.source.getLastModifiedAt(this.pipeline.getConfiguration());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BaseInputCollection)) {
            return false;
        }
        return this.source.equals(((BaseInputCollection)obj).source);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.source).toHashCode();
    }
}

