/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.types.PType;
import org.apache.crunch.util.UnionReadableData;

public class BaseUnionCollection<S>
extends PCollectionImpl<S> {
    private List<PCollectionImpl<S>> parents;
    private long size = 0L;
    private long lastModifiedAt = -1L;

    private static String flatName(List<? extends PCollectionImpl> collections) {
        StringBuilder sb = new StringBuilder("union(");
        for (int i = 0; i < collections.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(collections.get(i).getName());
        }
        return sb.append(')').toString();
    }

    protected BaseUnionCollection(List<? extends PCollectionImpl<S>> collections) {
        super(BaseUnionCollection.flatName(collections), collections.get(0).getPipeline());
        this.parents = ImmutableList.copyOf(collections);
        for (PCollectionImpl<S> parent : this.parents) {
            if (this.pipeline != parent.getPipeline()) {
                throw new IllegalStateException("Cannot union PCollections from different Pipeline instances");
            }
            this.size += parent.getSize();
            if (parent.getLastModifiedAt() <= this.lastModifiedAt) continue;
            this.lastModifiedAt = parent.getLastModifiedAt();
        }
    }

    @Override
    public void setBreakpoint() {
        super.setBreakpoint();
        for (PCollectionImpl<?> parent : this.getParents()) {
            parent.setBreakpoint();
        }
    }

    @Override
    protected long getSizeInternal() {
        return this.size;
    }

    @Override
    public long getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    @Override
    protected ReadableData<S> getReadableDataInternal() {
        ArrayList prds = Lists.newArrayList();
        for (PCollectionImpl<S> parent : this.parents) {
            if (parent instanceof BaseGroupedTable) {
                return this.materializedData();
            }
            prds.add(parent.asReadable(false));
        }
        return new UnionReadableData(prds);
    }

    @Override
    public PType<S> getPType() {
        return this.parents.get(0).getPType();
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.copyOf(this.parents);
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitUnionCollection(this);
    }
}

