/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.ReadableData;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.dist.collect.PTableBase;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.util.UnionReadableData;

public class BaseUnionTable<K, V>
extends PTableBase<K, V> {
    private PTableType<K, V> ptype;
    private List<PCollectionImpl<Pair<K, V>>> parents;
    private long size;
    private long lastModifiedAt = -1L;

    private static <K, V> String flatName(List<PTableBase<K, V>> tables) {
        StringBuilder sb = new StringBuilder("union(");
        for (int i = 0; i < tables.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(tables.get(i).getName());
        }
        return sb.append(')').toString();
    }

    protected BaseUnionTable(List<PTableBase<K, V>> tables) {
        super(BaseUnionTable.flatName(tables), tables.get(0).getPipeline());
        this.ptype = tables.get(0).getPTableType();
        this.pipeline = tables.get(0).getPipeline();
        this.parents = Lists.newArrayList();
        for (PTableBase<K, V> parent : tables) {
            if (this.pipeline != parent.getPipeline()) {
                throw new IllegalStateException("Cannot union PTables from different Pipeline instances");
            }
            this.parents.add(parent);
            this.size += parent.getSize();
            if (parent.getLastModifiedAt() <= this.lastModifiedAt) continue;
            this.lastModifiedAt = parent.getLastModifiedAt();
        }
    }

    @Override
    public void setBreakpoint() {
        super.setBreakpoint();
        for (PCollectionImpl<?> parent : this.getParents()) {
            parent.setBreakpoint();
        }
    }

    @Override
    protected long getSizeInternal() {
        return this.size;
    }

    @Override
    public long getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    @Override
    public PTableType<K, V> getPTableType() {
        return this.ptype;
    }

    @Override
    public PType<Pair<K, V>> getPType() {
        return this.ptype;
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.copyOf(this.parents);
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitUnionCollection(this.pipeline.getFactory().createUnionCollection(this.parents));
    }

    @Override
    protected ReadableData<Pair<K, V>> getReadableDataInternal() {
        ArrayList prds = Lists.newArrayList();
        for (PCollectionImpl<Pair<K, V>> parent : this.parents) {
            if (parent instanceof BaseGroupedTable) {
                return this.materializedData();
            }
            prds.add(parent.asReadable(false));
        }
        return new UnionReadableData<Pair<K, V>>(prds);
    }
}

