/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.collect;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.MRCollection;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.dist.collect.PTableBase;
import org.apache.crunch.impl.mr.plan.DoNode;
import org.apache.crunch.util.PartitionUtils;
import org.apache.hadoop.mapreduce.Job;

public class PGroupedTableImpl<K, V>
extends BaseGroupedTable<K, V>
implements MRCollection {
    private static final Log LOG = LogFactory.getLog(PGroupedTableImpl.class);

    PGroupedTableImpl(PTableBase<K, V> parent, GroupingOptions groupingOptions) {
        super(parent, groupingOptions);
    }

    public void configureShuffle(Job job) {
        this.ptype.configureShuffle(job, this.groupingOptions);
        if (this.groupingOptions == null || this.groupingOptions.getNumReducers() <= 0) {
            int numReduceTasks = PartitionUtils.getRecommendedPartitions(this, this.getPipeline().getConfiguration());
            if (numReduceTasks > 0) {
                job.setNumReduceTasks(numReduceTasks);
                LOG.info((Object)String.format("Setting num reduce tasks to %d", numReduceTasks));
            } else {
                LOG.warn((Object)"Attempted to set a negative number of reduce tasks");
            }
        }
    }

    @Override
    public void accept(PCollectionImpl.Visitor visitor) {
        visitor.visitGroupedTable(this);
    }

    @Override
    public DoNode createDoNode() {
        return DoNode.createFnNode(this.getName(), this.ptype.getInputMapFn(), this.ptype, this.doOptions);
    }

    public DoNode getGroupingNode() {
        return DoNode.createGroupingNode("", this.ptype);
    }
}

