/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.crunch.impl.mr.plan.DoNode;
import org.apache.hadoop.conf.Configuration;

public class JobNameBuilder {
    private static final Joiner JOINER = Joiner.on((String)"+");
    private static final Joiner CHILD_JOINER = Joiner.on((String)"/");
    private static final int DEFAULT_JOB_NAME_MAX_STACK_LENGTH = 60;
    private final String pipelineName;
    private final int jobID;
    private int jobSequence;
    private final int numOfJobs;
    List<String> rootStack = Lists.newArrayList();
    private final int maxStackNameLength;

    public JobNameBuilder(Configuration conf, String pipelineName, int jobID, int numOfJobs) {
        this.pipelineName = pipelineName;
        this.jobID = jobID;
        this.numOfJobs = numOfJobs;
        this.maxStackNameLength = conf.getInt("crunch.job.name.max.stack.length", 60);
    }

    public JobNameBuilder jobSequence(int jobSequence) {
        this.jobSequence = jobSequence;
        return this;
    }

    public void visit(DoNode node) {
        this.visit(node, this.rootStack);
    }

    public void visit(List<DoNode> nodes) {
        this.visit(nodes, this.rootStack);
    }

    private void visit(List<DoNode> nodes, List<String> stack) {
        if (nodes.size() == 1) {
            this.visit(nodes.get(0), stack);
        } else {
            ArrayList childStack = Lists.newArrayList();
            for (int i = 0; i < nodes.size(); ++i) {
                DoNode node = nodes.get(i);
                ArrayList subStack = Lists.newArrayList();
                this.visit(node, (List<String>)subStack);
                if (subStack.isEmpty()) continue;
                childStack.add("[" + JOINER.join((Iterable)subStack) + "]");
            }
            if (!childStack.isEmpty()) {
                stack.add("[" + CHILD_JOINER.join((Iterable)childStack) + "]");
            }
        }
    }

    private void visit(DoNode node, List<String> stack) {
        String name = node.getName();
        if (!name.isEmpty()) {
            stack.add(node.getName());
        }
        this.visit(node.getChildren(), stack);
    }

    public String build() {
        return String.format("%s: %s ID=%d (%d/%d)", this.pipelineName, JobNameBuilder.shortenRootStackName(JOINER.join(this.rootStack), this.maxStackNameLength), this.jobID, this.jobSequence, this.numOfJobs);
    }

    private static String shortenRootStackName(String s, int len) {
        int n = s.length();
        if (len <= 3) {
            return "...";
        }
        if (n <= len) {
            return s;
        }
        return s.substring(0, len - 3) + "...";
    }
}

