/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import com.google.common.base.Supplier;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.crunch.io.FormatBundle;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;

class CrunchInputSplit
extends InputSplit
implements Writable,
Configurable,
Supplier<InputSplit> {
    private InputSplit inputSplit;
    private int nodeIndex;
    private FormatBundle<? extends InputFormat<?, ?>> bundle;
    private Configuration conf;

    public CrunchInputSplit() {
    }

    public CrunchInputSplit(InputSplit inputSplit, FormatBundle<? extends InputFormat<?, ?>> bundle, int nodeIndex, Configuration conf) {
        this.inputSplit = inputSplit;
        this.bundle = bundle;
        this.nodeIndex = nodeIndex;
        this.conf = new Configuration(conf);
    }

    public InputSplit get() {
        return this.inputSplit;
    }

    public void setConf(Configuration conf) {
        this.conf = new Configuration(conf);
        if (this.bundle != null && conf != null) {
            this.bundle.configure(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() {
        return this.bundle.getFormatClass();
    }

    public long getLength() throws IOException, InterruptedException {
        return this.inputSplit.getLength();
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.inputSplit.getLocations();
    }

    public String toString() {
        return String.format("CrunchInputSplit(%s)", this.inputSplit);
    }

    public void readFields(DataInput in) throws IOException {
        if (this.conf == null) {
            this.conf = new Configuration();
        }
        this.nodeIndex = in.readInt();
        this.bundle = new FormatBundle();
        this.bundle.setConf(this.conf);
        this.bundle.readFields(in);
        this.bundle.configure(this.conf);
        Class inputSplitClass = this.readClass(in);
        this.inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)inputSplitClass, (Configuration)this.conf);
        if (this.inputSplit instanceof Writable) {
            ((Writable)this.inputSplit).readFields(in);
        } else {
            SerializationFactory factory = new SerializationFactory(this.conf);
            Deserializer deserializer = factory.getDeserializer(inputSplitClass);
            deserializer.open((InputStream)((DataInputStream)in));
            this.inputSplit = (InputSplit)deserializer.deserialize((Object)this.inputSplit);
            deserializer.close();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeIndex);
        this.bundle.write(out);
        Text.writeString((DataOutput)out, (String)this.inputSplit.getClass().getName());
        if (this.inputSplit instanceof Writable) {
            ((Writable)this.inputSplit).write(out);
        } else {
            SerializationFactory factory = new SerializationFactory(this.conf);
            Serializer serializer = factory.getSerializer(this.inputSplit.getClass());
            serializer.open((OutputStream)((Object)out));
            serializer.serialize((Object)this.inputSplit);
            serializer.close();
        }
    }

    private Class readClass(DataInput in) throws IOException {
        String className = Text.readString((DataInput)in);
        try {
            return this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("readObject can't find class", e);
        }
    }
}

