/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.impl.mr.run.CrunchInputSplit;
import org.apache.crunch.impl.mr.run.CrunchTaskContext;
import org.apache.crunch.impl.mr.run.NodeContext;
import org.apache.crunch.impl.mr.run.RTNode;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CrunchMapper
extends Mapper<Object, Object, Object, Object> {
    private static final Log LOG = LogFactory.getLog(CrunchMapper.class);
    private RTNode node;
    private CrunchTaskContext ctxt;
    private boolean debug;

    protected void setup(Mapper.Context context) {
        List<RTNode> nodes;
        if (this.ctxt == null) {
            this.ctxt = new CrunchTaskContext((TaskInputOutputContext<Object, Object, Object, Object>)context, NodeContext.MAP);
            this.debug = this.ctxt.isDebugRun();
        }
        if ((nodes = this.ctxt.getNodes()).size() == 1) {
            this.node = nodes.get(0);
        } else {
            CrunchInputSplit split = (CrunchInputSplit)context.getInputSplit();
            this.node = nodes.get(split.getNodeIndex());
        }
        this.node.initialize(this.ctxt);
    }

    protected void map(Object k, Object v, Mapper.Context context) {
        if (this.debug) {
            try {
                this.node.process(k, v);
            }
            catch (Exception e) {
                LOG.error((Object)"Mapper exception", (Throwable)e);
            }
        } else {
            this.node.process(k, v);
        }
    }

    protected void cleanup(Mapper.Context context) {
        this.node.cleanup();
        this.ctxt.cleanup();
    }
}

