/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.hadoop.mapreduce.TaskAttemptContextFactory;
import org.apache.crunch.io.FormatBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.ReflectionUtils;

public class CrunchOutputs<K, V> {
    public static final String CRUNCH_OUTPUTS = "crunch.outputs.dir";
    public static final String CRUNCH_DISABLE_OUTPUT_COUNTERS = "crunch.disable.output.counters";
    private static final char RECORD_SEP = ',';
    private static final char FIELD_SEP = ';';
    private static final Joiner JOINER = Joiner.on((char)';');
    private static final Splitter SPLITTER = Splitter.on((char)';');
    private static final String BASE_OUTPUT_NAME = "mapreduce.output.basename";
    private static final String COUNTERS_GROUP = CrunchOutputs.class.getName();
    private final TaskInputOutputContext<?, ?, K, V> baseContext;
    private final Map<String, OutputConfig> namedOutputs;
    private final Map<String, RecordWriter<K, V>> recordWriters;
    private final Map<String, TaskAttemptContext> taskContextCache;
    private final boolean disableOutputCounters;

    public static void addNamedOutput(Job job, String name, Class<? extends OutputFormat> outputFormatClass, Class keyClass, Class valueClass) {
        CrunchOutputs.addNamedOutput(job, name, FormatBundle.forOutput(outputFormatClass), keyClass, valueClass);
    }

    public static void addNamedOutput(Job job, String name, FormatBundle<? extends OutputFormat> outputBundle, Class keyClass, Class valueClass) {
        Configuration conf = job.getConfiguration();
        String inputs = JOINER.join((Object)name, (Object)outputBundle.serialize(), new Object[]{keyClass.getName(), valueClass.getName()});
        String existing = conf.get(CRUNCH_OUTPUTS);
        conf.set(CRUNCH_OUTPUTS, existing == null ? inputs : existing + ',' + inputs);
    }

    private static Map<String, OutputConfig> getNamedOutputs(TaskInputOutputContext<?, ?, ?, ?> context) {
        HashMap out = Maps.newHashMap();
        Configuration conf = context.getConfiguration();
        for (String input : Splitter.on((char)',').split((CharSequence)conf.get(CRUNCH_OUTPUTS))) {
            ArrayList fields = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)input));
            String name = (String)fields.get(0);
            FormatBundle bundle = FormatBundle.fromSerialized((String)fields.get(1), conf);
            try {
                Class<?> keyClass = Class.forName((String)fields.get(2));
                Class<?> valueClass = Class.forName((String)fields.get(3));
                out.put(name, new OutputConfig(bundle, keyClass, valueClass));
            }
            catch (ClassNotFoundException e) {
                throw new CrunchRuntimeException(e);
            }
        }
        return out;
    }

    public CrunchOutputs(TaskInputOutputContext<?, ?, K, V> context) {
        this.baseContext = context;
        this.namedOutputs = CrunchOutputs.getNamedOutputs(context);
        this.recordWriters = Maps.newHashMap();
        this.taskContextCache = Maps.newHashMap();
        this.disableOutputCounters = context.getConfiguration().getBoolean(CRUNCH_DISABLE_OUTPUT_COUNTERS, false);
    }

    public void write(String namedOutput, K key, V value) throws IOException, InterruptedException {
        if (!this.namedOutputs.containsKey(namedOutput)) {
            throw new IllegalArgumentException("Undefined named output '" + namedOutput + "'");
        }
        TaskAttemptContext taskContext = this.getContext(namedOutput);
        if (!this.disableOutputCounters) {
            this.baseContext.getCounter(COUNTERS_GROUP, namedOutput).increment(1L);
        }
        this.getRecordWriter(taskContext, namedOutput).write(key, value);
    }

    public void close() throws IOException, InterruptedException {
        for (RecordWriter<K, V> writer : this.recordWriters.values()) {
            writer.close(this.baseContext);
        }
    }

    private TaskAttemptContext getContext(String nameOutput) throws IOException {
        TaskAttemptContext taskContext = this.taskContextCache.get(nameOutput);
        if (taskContext != null) {
            return taskContext;
        }
        OutputConfig outConfig = this.namedOutputs.get(nameOutput);
        Configuration conf = new Configuration(this.baseContext.getConfiguration());
        Job job = new Job(conf);
        job.getConfiguration().set("crunch.namedoutput", nameOutput);
        job.setOutputFormatClass(outConfig.bundle.getFormatClass());
        job.setOutputKeyClass(outConfig.keyClass);
        job.setOutputValueClass(outConfig.valueClass);
        outConfig.bundle.configure(job.getConfiguration());
        taskContext = TaskAttemptContextFactory.create(job.getConfiguration(), this.baseContext.getTaskAttemptID());
        this.taskContextCache.put(nameOutput, taskContext);
        return taskContext;
    }

    private synchronized RecordWriter<K, V> getRecordWriter(TaskAttemptContext taskContext, String namedOutput) throws IOException, InterruptedException {
        RecordWriter writer = this.recordWriters.get(namedOutput);
        if (writer == null) {
            taskContext.getConfiguration().set(BASE_OUTPUT_NAME, namedOutput);
            try {
                OutputFormat format = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)taskContext.getConfiguration());
                writer = format.getRecordWriter(taskContext);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            this.recordWriters.put(namedOutput, writer);
        }
        return writer;
    }

    private static class OutputConfig<K, V> {
        public FormatBundle<OutputFormat<K, V>> bundle;
        public Class<K> keyClass;
        public Class<V> valueClass;

        public OutputConfig(FormatBundle<OutputFormat<K, V>> bundle, Class<K> keyClass, Class<V> valueClass) {
            this.bundle = bundle;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
        }
    }
}

