/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;

public class FormatBundle<K>
implements Serializable,
Writable,
Configurable {
    private Class<K> formatClass;
    private Map<String, String> extraConf;
    private Configuration conf;

    public static <T> FormatBundle<T> fromSerialized(String serialized, Configuration conf) {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)serialized));
        try {
            FormatBundle bundle = new FormatBundle();
            bundle.setConf(conf);
            bundle.readFields(new DataInputStream(bais));
            return bundle;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends InputFormat<?, ?>> FormatBundle<T> forInput(Class<T> inputFormatClass) {
        return new FormatBundle<T>(inputFormatClass);
    }

    public static <T extends OutputFormat<?, ?>> FormatBundle<T> forOutput(Class<T> outputFormatClass) {
        return new FormatBundle<T>(outputFormatClass);
    }

    public FormatBundle() {
    }

    private FormatBundle(Class<K> formatClass) {
        this.formatClass = formatClass;
        this.extraConf = Maps.newHashMap();
    }

    public FormatBundle<K> set(String key, String value) {
        this.extraConf.put(key, value);
        return this;
    }

    public Class<K> getFormatClass() {
        return this.formatClass;
    }

    public Configuration configure(Configuration conf) {
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            conf.set(e.getKey(), e.getValue());
        }
        return conf;
    }

    public String serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(baos);
            this.write(dos);
            return Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.formatClass.getSimpleName();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.formatClass).append(this.extraConf).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof FormatBundle)) {
            return false;
        }
        FormatBundle oib = (FormatBundle)other;
        return this.formatClass.equals(oib.formatClass) && ((Object)this.extraConf).equals(oib.extraConf);
    }

    public void readFields(DataInput in) throws IOException {
        this.formatClass = this.readClass(in);
        int ecSize = in.readInt();
        this.extraConf = Maps.newHashMap();
        for (int i = 0; i < ecSize; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.extraConf.put(key, value);
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.formatClass.getName());
        out.writeInt(this.extraConf.size());
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            Text.writeString((DataOutput)out, (String)e.getKey());
            Text.writeString((DataOutput)out, (String)e.getValue());
        }
    }

    private Class readClass(DataInput in) throws IOException {
        String className = Text.readString((DataInput)in);
        try {
            return this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("readObject can't find class", e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

