/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SourceTargetHelper {
    public static long getPathSize(Configuration conf, Path path) throws IOException {
        return SourceTargetHelper.getPathSize(path.getFileSystem(conf), path);
    }

    public static long getPathSize(FileSystem fs, Path path) throws IOException {
        FileStatus[] stati = fs.globStatus(path);
        if (stati == null || stati.length == 0) {
            return -1L;
        }
        long size = 0L;
        for (FileStatus status : stati) {
            if (status.isDir()) {
                for (FileStatus st : fs.listStatus(status.getPath())) {
                    size += st.getLen();
                }
                continue;
            }
            size += status.getLen();
        }
        return size;
    }

    public static long getLastModifiedAt(FileSystem fs, Path path) throws IOException {
        FileStatus[] stati = fs.globStatus(path);
        if (stati == null || stati.length == 0) {
            return -1L;
        }
        long lastMod = -1L;
        for (FileStatus status : stati) {
            if (lastMod >= status.getModificationTime()) continue;
            lastMod = status.getModificationTime();
        }
        return lastMod;
    }
}

