/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro;

import org.apache.avro.mapred.AvroWrapper;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.avro.AvroFileSourceTarget;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroOutputFormat;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;

public class AvroFileTarget
extends FileTargetImpl {
    public AvroFileTarget(String path) {
        this(new Path(path));
    }

    public AvroFileTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public AvroFileTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, AvroOutputFormat.class, fileNamingScheme);
    }

    @Override
    public String toString() {
        return "Avro(" + this.path.toString() + ")";
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        if (!(ptype instanceof AvroType)) {
            return false;
        }
        handler.configure(this, ptype);
        return true;
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        AvroType atype = (AvroType)ptype;
        FormatBundle<AvroOutputFormat> bundle = FormatBundle.forOutput(AvroOutputFormat.class);
        String schemaParam = null;
        schemaParam = name == null ? "avro.output.schema" : "avro.output.schema." + name;
        bundle.set(schemaParam, atype.getSchema().toString());
        AvroMode.fromType(atype).configure(bundle);
        this.configureForMapReduce(job, AvroWrapper.class, NullWritable.class, bundle, outputPath, name);
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (ptype instanceof AvroType) {
            return new AvroFileSourceTarget(this.path, (AvroType)ptype);
        }
        return null;
    }
}

