/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro;

import java.io.IOException;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroPathPerKeyOutputFormat;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;

public class AvroPathPerKeyTarget
extends FileTargetImpl {
    private static final Log LOG = LogFactory.getLog(AvroPathPerKeyTarget.class);

    public AvroPathPerKeyTarget(String path) {
        this(new Path(path));
    }

    public AvroPathPerKeyTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public AvroPathPerKeyTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, AvroPathPerKeyOutputFormat.class, fileNamingScheme);
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        if (ptype instanceof PTableType && ptype instanceof AvroType && String.class.equals(((PTableType)ptype).getKeyType().getTypeClass())) {
            handler.configure(this, ptype);
            return true;
        }
        return false;
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        AvroType atype = (AvroType)((PTableType)ptype).getValueType();
        FormatBundle<AvroPathPerKeyOutputFormat> bundle = FormatBundle.forOutput(AvroPathPerKeyOutputFormat.class);
        String schemaParam = name == null ? "avro.output.schema" : "avro.output.schema." + name;
        bundle.set(schemaParam, atype.getSchema().toString());
        AvroMode.fromType(atype).configure(bundle);
        this.configureForMapReduce(job, AvroWrapper.class, NullWritable.class, bundle, outputPath, name);
    }

    @Override
    public void handleOutputs(Configuration conf, Path workingPath, int index) throws IOException {
        Path base;
        FileSystem srcFs = workingPath.getFileSystem(conf);
        if (!srcFs.exists(base = new Path(workingPath, "out" + index))) {
            LOG.warn((Object)("Nothing to copy from " + base));
            return;
        }
        Path[] keys = FileUtil.stat2Paths((FileStatus[])srcFs.listStatus(base));
        FileSystem dstFs = this.path.getFileSystem(conf);
        if (!dstFs.exists(this.path)) {
            dstFs.mkdirs(this.path);
        }
        boolean sameFs = AvroPathPerKeyTarget.isCompatible(srcFs, this.path);
        for (Path key : keys) {
            Path[] srcs = FileUtil.stat2Paths((FileStatus[])srcFs.listStatus(key), (Path)key);
            Path targetPath = new Path(this.path, key.getName());
            dstFs.mkdirs(targetPath);
            for (Path s : srcs) {
                Path d = this.getDestFile(conf, s, targetPath, s.getName().contains("-m-"));
                if (sameFs) {
                    srcFs.rename(s, d);
                    continue;
                }
                FileUtil.copy((FileSystem)srcFs, (Path)s, (FileSystem)dstFs, (Path)d, (boolean)true, (boolean)true, (Configuration)conf);
            }
        }
        dstFs.create(this.getSuccessIndicator(), true).close();
    }

    @Override
    public String toString() {
        return "AvroFilePerKey(" + this.path + ")";
    }
}

