/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.Source;
import org.apache.crunch.impl.mr.run.CrunchInputFormat;
import org.apache.crunch.io.CompositePathIterable;
import org.apache.crunch.io.CrunchInputs;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.SourceTargetHelper;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;

public class FileSourceImpl<T>
implements Source<T> {
    private static final Log LOG = LogFactory.getLog(FileSourceImpl.class);
    @Deprecated
    protected final Path path;
    protected final List<Path> paths;
    protected final PType<T> ptype;
    protected final FormatBundle<? extends InputFormat> inputBundle;

    public FileSourceImpl(Path path, PType<T> ptype, Class<? extends InputFormat> inputFormatClass) {
        this(path, ptype, FormatBundle.forInput(inputFormatClass));
    }

    public FileSourceImpl(Path path, PType<T> ptype, FormatBundle<? extends InputFormat> inputBundle) {
        this((List<Path>)Lists.newArrayList((Object[])new Path[]{path}), ptype, inputBundle);
    }

    public FileSourceImpl(List<Path> paths, PType<T> ptype, Class<? extends InputFormat> inputFormatClass) {
        this(paths, ptype, FormatBundle.forInput(inputFormatClass));
    }

    public FileSourceImpl(List<Path> paths, PType<T> ptype, FormatBundle<? extends InputFormat> inputBundle) {
        this.path = paths.isEmpty() ? null : paths.get(0);
        this.paths = paths;
        this.ptype = ptype;
        this.inputBundle = inputBundle;
    }

    @Deprecated
    public Path getPath() {
        if (this.paths.isEmpty()) {
            return null;
        }
        if (this.paths.size() > 1) {
            LOG.warn((Object)("getPath() called for source with multiple paths, only returning first. Source: " + this));
        }
        return this.paths.get(0);
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    @Override
    public Source<T> inputConf(String key, String value) {
        this.inputBundle.set(key, value);
        return this;
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter() {
        return this.ptype.getConverter();
    }

    @Override
    public void configureSource(Job job, int inputId) throws IOException {
        job.setInputFormatClass(CrunchInputFormat.class);
        CrunchInputs.addInputPaths(job, this.paths, this.inputBundle, inputId);
    }

    public FormatBundle<? extends InputFormat> getBundle() {
        return this.inputBundle;
    }

    @Override
    public PType<T> getType() {
        return this.ptype;
    }

    @Override
    public long getSize(Configuration configuration) {
        long size = 0L;
        for (Path path : this.paths) {
            try {
                size += SourceTargetHelper.getPathSize(configuration, path);
            }
            catch (IOException e) {
                LOG.warn((Object)String.format("Exception thrown looking up size of: %s", path), (Throwable)e);
                throw new IllegalStateException("Failed to get the file size of:" + path, e);
            }
        }
        return size;
    }

    protected Iterable<T> read(Configuration conf, FileReaderFactory<T> readerFactory) throws IOException {
        ArrayList iterables = Lists.newArrayList();
        for (Path path : this.paths) {
            FileSystem fs = path.getFileSystem(conf);
            iterables.add(CompositePathIterable.create(fs, path, readerFactory));
        }
        return Iterables.concat((Iterable)iterables);
    }

    protected String pathsAsString() {
        if (this.paths.size() == 1) {
            return this.paths.get(0).toString();
        }
        return this.paths.toString();
    }

    @Override
    public long getLastModifiedAt(Configuration conf) {
        long lastMod = -1L;
        for (Path path : this.paths) {
            try {
                FileSystem fs = path.getFileSystem(conf);
                long lm = SourceTargetHelper.getLastModifiedAt(fs, path);
                if (lm <= lastMod) continue;
                lastMod = lm;
            }
            catch (IOException e) {
                LOG.error((Object)("Could not determine last modification time for source: " + this.toString()), (Throwable)e);
            }
        }
        return lastMod;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        FileSourceImpl o = (FileSourceImpl)other;
        return this.ptype.equals(o.ptype) && ((Object)this.paths).equals(o.paths) && this.inputBundle.equals(o.inputBundle);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.ptype).append(this.paths).append(this.inputBundle).toHashCode();
    }

    public String toString() {
        return this.inputBundle.getName() + "(" + this.pathsAsString() + ")";
    }
}

