/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.parquet;

import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.AutoClosingIterator;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.avro.AvroReadSupport;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.schema.MessageType;

class AvroParquetFileReaderFactory<T>
implements FileReaderFactory<T> {
    private AvroType<T> avroType;

    public AvroParquetFileReaderFactory(AvroType<T> avroType) {
        this.avroType = avroType;
    }

    @Override
    public Iterator<T> read(FileSystem fs, Path path) {
        ParquetReader reader;
        Path p = fs.makeQualified(path);
        try {
            reader = new ParquetReader(p, new CrunchAvroReadSupport<T>(this.avroType));
        }
        catch (IOException e) {
            throw new CrunchRuntimeException(e);
        }
        return new AutoClosingIterator((Closeable)reader, new UnmodifiableIterator<T>(){
            private T next;

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    this.next = reader.read();
                }
                catch (IOException e) {
                    throw new CrunchRuntimeException(e);
                }
                return this.next != null;
            }

            public T next() {
                if (this.hasNext()) {
                    Object ret = this.next;
                    this.next = null;
                    return ret;
                }
                throw new NoSuchElementException();
            }
        });
    }

    static class CrunchAvroReadSupport<T extends IndexedRecord>
    extends AvroReadSupport<T> {
        private AvroType<T> avroType;

        public CrunchAvroReadSupport(AvroType<T> avroType) {
            this.avroType = avroType;
        }

        public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
            if (this.avroType != null) {
                CrunchAvroReadSupport.setRequestedProjection((Configuration)configuration, (Schema)this.avroType.getSchema());
            }
            return super.init(configuration, keyValueMetaData, fileSchema);
        }
    }
}

