/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.seq;

import org.apache.crunch.SourceTarget;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.io.seq.SeqFileSourceTarget;
import org.apache.crunch.io.seq.SeqFileTableSourceTarget;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

public class SeqFileTarget
extends FileTargetImpl {
    public SeqFileTarget(String path) {
        this(new Path(path));
    }

    public SeqFileTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public SeqFileTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, SequenceFileOutputFormat.class, fileNamingScheme);
    }

    @Override
    public String toString() {
        return "SeqFile(" + this.path.toString() + ")";
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (ptype instanceof PTableType) {
            return new SeqFileTableSourceTarget(this.path, (PTableType)ptype);
        }
        return new SeqFileSourceTarget<T>(this.path, ptype);
    }
}

