/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.AutoClosingIterator;
import org.apache.crunch.io.text.LineParser;
import org.apache.crunch.types.PType;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TextFileReaderFactory<T>
implements FileReaderFactory<T> {
    private static final Log LOG = LogFactory.getLog(TextFileReaderFactory.class);
    private final LineParser<T> parser;

    public TextFileReaderFactory(PType<T> ptype) {
        this(LineParser.forType(ptype));
    }

    public TextFileReaderFactory(LineParser<T> parser) {
        this.parser = parser;
    }

    @Override
    public Iterator<T> read(FileSystem fs, Path path) {
        FSDataInputStream is;
        this.parser.initialize();
        try {
            is = fs.open(path);
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
        final BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
        return new AutoClosingIterator(reader, new UnmodifiableIterator<T>(){
            boolean nextChecked = false;
            private String nextLine;

            public boolean hasNext() {
                if (this.nextChecked) {
                    return this.nextLine != null;
                }
                try {
                    this.nextChecked = true;
                    this.nextLine = reader.readLine();
                    return this.nextLine != null;
                }
                catch (IOException e) {
                    LOG.info((Object)"Exception reading text file stream", (Throwable)e);
                    return false;
                }
            }

            public T next() {
                if (!this.nextChecked && !this.hasNext()) {
                    return null;
                }
                this.nextChecked = false;
                return TextFileReaderFactory.this.parser.parse(this.nextLine);
            }
        });
    }
}

