/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.join;

import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.join.FullOuterJoinFn;
import org.apache.crunch.lib.join.InnerJoinFn;
import org.apache.crunch.lib.join.JoinFn;
import org.apache.crunch.lib.join.JoinStrategy;
import org.apache.crunch.lib.join.JoinType;
import org.apache.crunch.lib.join.JoinUtils;
import org.apache.crunch.lib.join.LeftOuterJoinFn;
import org.apache.crunch.lib.join.RightOuterJoinFn;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PTypeFamily;

public class DefaultJoinStrategy<K, U, V>
implements JoinStrategy<K, U, V> {
    private final int numReducers;

    public DefaultJoinStrategy() {
        this(-1);
    }

    public DefaultJoinStrategy(int numReducers) {
        this.numReducers = numReducers;
    }

    @Override
    public PTable<K, Pair<U, V>> join(PTable<K, U> left, PTable<K, V> right, JoinType joinType) {
        switch (joinType) {
            case INNER_JOIN: {
                return this.join(left, right, new InnerJoinFn(left.getKeyType(), left.getValueType()));
            }
            case LEFT_OUTER_JOIN: {
                return this.join(left, right, new LeftOuterJoinFn(left.getKeyType(), left.getValueType()));
            }
            case RIGHT_OUTER_JOIN: {
                return this.join(left, right, new RightOuterJoinFn(left.getKeyType(), left.getValueType()));
            }
            case FULL_OUTER_JOIN: {
                return this.join(left, right, new FullOuterJoinFn(left.getKeyType(), left.getValueType()));
            }
        }
        throw new UnsupportedOperationException("Join type " + (Object)((Object)joinType) + " is not supported");
    }

    public PTable<K, Pair<U, V>> join(PTable<K, U> left, PTable<K, V> right, JoinFn<K, U, V> joinFn) {
        PTypeFamily ptf = left.getTypeFamily();
        PGroupedTable<Pair<K, Integer>, Pair<U, Pair<U, V>>> grouped = DefaultJoinStrategy.preJoin(left, right, this.numReducers);
        PTableType<K, Pair<U, V>> ret = ptf.tableOf(left.getKeyType(), ptf.pairs(left.getValueType(), right.getValueType()));
        return grouped.parallelDo(joinFn.getJoinType() + grouped.getName(), joinFn, (PTableType<Pair<K, Integer>, Pair<U, Pair<U, V>>>)ret);
    }

    static <K, U, V> PGroupedTable<Pair<K, Integer>, Pair<U, V>> preJoin(PTable<K, U> left, PTable<K, V> right, int numReducers) {
        PTypeFamily ptf = left.getTypeFamily();
        PTableType<Pair<K, Integer>, Pair<U, V>> ptt = ptf.tableOf(ptf.pairs(left.getKeyType(), ptf.ints()), ptf.pairs(left.getValueType(), right.getValueType()));
        PTable<Pair<Pair<K, Integer>, Integer>, Pair<U, Pair<U, V>>> tag1 = left.parallelDo("joinTagLeft", new MapFn<Pair<K, U>, Pair<Pair<K, Integer>, Pair<U, V>>>(){

            @Override
            public Pair<Pair<K, Integer>, Pair<U, V>> map(Pair<K, U> input) {
                return Pair.of(Pair.of(input.first(), 0), Pair.of(input.second(), null));
            }
        }, (PTableType<Pair<K, Integer>, U>)ptt);
        PTable<Pair<K, Integer>, Pair<U, V>> tag2 = right.parallelDo("joinTagRight", new MapFn<Pair<K, V>, Pair<Pair<K, Integer>, Pair<U, V>>>(){

            @Override
            public Pair<Pair<K, Integer>, Pair<U, V>> map(Pair<K, V> input) {
                return Pair.of(Pair.of(input.first(), 1), Pair.of(null, input.second()));
            }
        }, ptt);
        GroupingOptions.Builder optionsBuilder = GroupingOptions.builder();
        optionsBuilder.requireSortedKeys();
        optionsBuilder.partitionerClass(JoinUtils.getPartitionerClass(ptf));
        if (numReducers > 0) {
            optionsBuilder.numReducers(numReducers);
        }
        return tag1.union((PTable<Pair<Pair<K, Integer>, Integer>, Pair<U, Pair<U, V>>>)tag2).groupByKey(optionsBuilder.build());
    }
}

