/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.join;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.crunch.Emitter;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.join.JoinFn;
import org.apache.crunch.types.PType;

public class RightOuterJoinFn<K, U, V>
extends JoinFn<K, U, V> {
    private transient K lastKey;
    private transient List<U> leftValues;

    public RightOuterJoinFn(PType<K> keyType, PType<U> leftValueType) {
        super(keyType, leftValueType);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.lastKey = null;
        this.leftValues = Lists.newArrayList();
    }

    @Override
    public void join(K key, int id, Iterable<Pair<U, V>> pairs, Emitter<Pair<K, Pair<U, V>>> emitter) {
        if (!key.equals(this.lastKey)) {
            this.lastKey = this.keyType.getDetachedValue(key);
            this.leftValues.clear();
        }
        if (id == 0) {
            for (Pair<U, V> pair : pairs) {
                if (pair.first() == null) continue;
                this.leftValues.add(this.leftValueType.getDetachedValue(pair.first()));
            }
        } else {
            for (Pair<U, V> pair : pairs) {
                if (this.leftValues.isEmpty()) {
                    this.leftValues.add(null);
                }
                for (U u : this.leftValues) {
                    emitter.emit(Pair.of(this.lastKey, Pair.of(u, pair.second())));
                }
            }
        }
    }

    @Override
    public String getJoinType() {
        return "rightOuterJoin";
    }
}

