/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.sort;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.crunch.MapFn;
import org.apache.crunch.Tuple;
import org.apache.crunch.lib.Sort;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.TupleFactory;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.avro.Avros;

public class SortFns {
    public static <S> Schema createOrderedTupleSchema(PType<S> ptype, Sort.ColumnOrder[] orders) {
        String tupleName = "tuple" + UUID.randomUUID().toString().replace('-', 'x');
        Schema schema = Schema.createRecord((String)tupleName, (String)"", (String)"crunch", (boolean)false);
        ArrayList fields = Lists.newArrayList();
        AvroType parentAvroType = (AvroType)ptype;
        Schema parentAvroSchema = parentAvroType.getSchema();
        for (int index = 0; index < orders.length; ++index) {
            Sort.ColumnOrder columnOrder = orders[index];
            AvroType atype = (AvroType)ptype.getSubTypes().get(index);
            Schema fieldSchema = atype.getSchema();
            String fieldName = ((Schema.Field)parentAvroSchema.getFields().get(index)).name();
            Schema.Field.Order order = columnOrder.order() == Sort.Order.DESCENDING ? Schema.Field.Order.DESCENDING : Schema.Field.Order.ASCENDING;
            fields.add(new Schema.Field(fieldName, fieldSchema, "", null, order));
        }
        schema.setFields((List)fields);
        return schema;
    }

    public static class KeyExtraction<V extends Tuple> {
        private PType<V> ptype;
        private final Sort.ColumnOrder[] columnOrder;
        private final int[] cols;
        private MapFn<V, Object> byFn;
        private PType<Object> keyPType;

        public KeyExtraction(PType<V> ptype, Sort.ColumnOrder[] columnOrder) {
            this.ptype = ptype;
            this.columnOrder = columnOrder;
            this.cols = new int[columnOrder.length];
            for (int i = 0; i < columnOrder.length; ++i) {
                this.cols[i] = columnOrder[i].column() - 1;
            }
            this.init();
        }

        private void init() {
            List<PType> pt = this.ptype.getSubTypes();
            PTypeFamily ptf = this.ptype.getFamily();
            if (this.cols.length == 1) {
                this.byFn = new SingleKeyFn<V, Object>(this.cols[0]);
                this.keyPType = pt.get(this.cols[0]);
            } else {
                TupleFactory<Tuple> tf;
                switch (this.cols.length) {
                    case 2: {
                        tf = TupleFactory.PAIR;
                        this.keyPType = ptf.pairs(pt.get(this.cols[0]), pt.get(this.cols[1]));
                        break;
                    }
                    case 3: {
                        tf = TupleFactory.TUPLE3;
                        this.keyPType = ptf.triples(pt.get(this.cols[0]), pt.get(this.cols[1]), pt.get(this.cols[2]));
                        break;
                    }
                    case 4: {
                        tf = TupleFactory.TUPLE4;
                        this.keyPType = ptf.quads(pt.get(this.cols[0]), pt.get(this.cols[1]), pt.get(this.cols[2]), pt.get(this.cols[3]));
                        break;
                    }
                    default: {
                        PType[] pts = new PType[this.cols.length];
                        for (int i = 0; i < pts.length; ++i) {
                            pts[i] = pt.get(this.cols[i]);
                        }
                        tf = TupleFactory.TUPLEN;
                        this.keyPType = ptf.tuples(pts);
                    }
                }
                if (ptf == AvroTypeFamily.getInstance()) {
                    Schema s = SortFns.createOrderedTupleSchema(this.keyPType, this.columnOrder);
                    this.keyPType = Avros.generics(s);
                    this.byFn = new AvroGenericFn(this.cols, s);
                } else {
                    this.byFn = new TupleKeyFn<V, Object>(this.cols, tf);
                }
            }
        }

        public MapFn<V, Object> getByFn() {
            return this.byFn;
        }

        public PType<Object> getKeyType() {
            return this.keyPType;
        }
    }

    public static class AvroGenericFn<V extends Tuple>
    extends MapFn<V, GenericRecord> {
        private final int[] indices;
        private final String schemaJson;
        private transient Schema schema;

        public AvroGenericFn(int[] indices, Schema schema) {
            this.indices = indices;
            this.schemaJson = schema.toString();
        }

        @Override
        public void initialize() {
            this.schema = new Schema.Parser().parse(this.schemaJson);
        }

        @Override
        public GenericRecord map(V input) {
            GenericData.Record rec = new GenericData.Record(this.schema);
            for (int i = 0; i < this.indices.length; ++i) {
                rec.put(i, input.get(this.indices[i]));
            }
            return rec;
        }
    }

    public static class TupleKeyFn<V extends Tuple, K extends Tuple>
    extends MapFn<V, K> {
        private final int[] indices;
        private final TupleFactory tupleFactory;

        public TupleKeyFn(int[] indices, TupleFactory tupleFactory) {
            this.indices = indices;
            this.tupleFactory = tupleFactory;
        }

        @Override
        public K map(V input) {
            Object[] values = new Object[this.indices.length];
            for (int i = 0; i < this.indices.length; ++i) {
                values[i] = input.get(this.indices[i]);
            }
            return (K)this.tupleFactory.makeTuple(values);
        }
    }

    public static class SingleKeyFn<V extends Tuple, K>
    extends MapFn<V, K> {
        private final int index;

        public SingleKeyFn(int index) {
            this.index = index;
        }

        @Override
        public K map(V input) {
            return (K)input.get(this.index);
        }
    }
}

