/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.sort;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.crunch.lib.Sort;
import org.apache.crunch.types.writable.TupleWritable;
import org.apache.crunch.types.writable.WritableType;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class TupleWritableComparator
extends WritableComparator
implements Configurable {
    private static final String CRUNCH_ORDERING_PROPERTY = "crunch.ordering";
    private Configuration conf;
    private Sort.ColumnOrder[] columnOrders;

    public TupleWritableComparator() {
        super(TupleWritable.class, true);
    }

    public static void configureOrdering(Configuration conf, WritableType[] types, Sort.ColumnOrder[] columnOrders) {
        ArrayList ordering = Lists.newArrayList();
        for (int i = 0; i < types.length; ++i) {
            ordering.add(columnOrders[i].order().name());
        }
        conf.set(CRUNCH_ORDERING_PROPERTY, Joiner.on((String)",").join((Iterable)ordering));
    }

    public int compare(WritableComparable a, WritableComparable b) {
        TupleWritable ta = (TupleWritable)a;
        TupleWritable tb = (TupleWritable)b;
        for (int index = 0; index < this.columnOrders.length; ++index) {
            int cmp;
            Writable v2;
            int order = 1;
            if (this.columnOrders[index].order() == Sort.Order.ASCENDING) {
                order = 1;
            } else {
                if (this.columnOrders[index].order() != Sort.Order.DESCENDING) continue;
                order = -1;
            }
            if (!ta.has(index) && !tb.has(index)) continue;
            if (ta.has(index) && !tb.has(index)) {
                return order;
            }
            if (!ta.has(index) && tb.has(index)) {
                return -order;
            }
            Writable v1 = ta.get(index);
            if (v1 == (v2 = tb.get(index)) || v1 == null || v1.equals(v2) || !(v1 instanceof WritableComparable && v2 instanceof WritableComparable ? (cmp = ((WritableComparable)v1).compareTo((Object)((WritableComparable)v2))) != 0 : (cmp = v1.hashCode() - v2.hashCode()) != 0)) continue;
            return order * cmp;
        }
        return 0;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (conf != null) {
            String ordering = conf.get(CRUNCH_ORDERING_PROPERTY);
            String[] columnOrderNames = ordering.split(",");
            this.columnOrders = new Sort.ColumnOrder[columnOrderNames.length];
            for (int i = 0; i < this.columnOrders.length; ++i) {
                Sort.Order order = Sort.Order.valueOf(columnOrderNames[i]);
                this.columnOrders[i] = Sort.ColumnOrder.by(i + 1, order);
            }
        }
    }
}

