/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;

public class MapDeepCopier<T>
implements DeepCopier<Map<String, T>> {
    private final PType<T> ptype;

    public MapDeepCopier(PType<T> ptype) {
        this.ptype = ptype;
    }

    @Override
    public void initialize(Configuration conf) {
        this.ptype.initialize(conf);
    }

    @Override
    public Map<String, T> deepCopy(Map<String, T> source) {
        if (source == null) {
            return null;
        }
        HashMap deepCopyMap = Maps.newHashMap();
        for (Map.Entry<String, T> entry : source.entrySet()) {
            deepCopyMap.put(entry.getKey(), this.ptype.getDetachedValue(entry.getValue()));
        }
        return deepCopyMap;
    }
}

