/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class AvroOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    public static <S> DataFileWriter<S> getDataFileWriter(Path path, Configuration conf) throws IOException {
        Schema schema = null;
        String outputName = conf.get("crunch.namedoutput");
        schema = outputName != null && !outputName.isEmpty() ? new Schema.Parser().parse(conf.get("avro.output.schema." + outputName)) : AvroJob.getOutputSchema((Configuration)conf);
        DataFileWriter writer = new DataFileWriter(AvroMode.fromConfiguration(conf).getWriter(schema));
        JobConf jc = new JobConf(conf);
        if (org.apache.hadoop.mapred.FileOutputFormat.getCompressOutput((JobConf)jc)) {
            int level = conf.getInt("avro.mapred.deflate.level", 1);
            String codecName = conf.get("avro.output.codec", "deflate");
            CodecFactory codec = codecName.equals("deflate") ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            writer.setCodec(codec);
        }
        writer.setSyncInterval(jc.getInt("avro.mapred.sync.interval", 16000));
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path)) {
            writer.create(schema, (OutputStream)fs.append(path));
        } else {
            writer.create(schema, (OutputStream)fs.create(path));
        }
        return writer;
    }

    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path path = this.getDefaultWorkFile(context, ".avro");
        final DataFileWriter writer = AvroOutputFormat.getDataFileWriter(path, conf);
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){

            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                writer.append(wrapper.datum());
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                writer.close();
            }
        };
    }
}

