/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.io.IOException;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class AvroTextOutputFormat<K, V>
extends TextOutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        RecordWriter recordWriter = super.getRecordWriter(context);
        return new DatumRecordTextWriter(recordWriter);
    }

    class DatumRecordTextWriter
    extends RecordWriter<K, V> {
        private RecordWriter lineRecordWriter;

        DatumRecordTextWriter(RecordWriter recordWriter) {
            this.lineRecordWriter = recordWriter;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordWriter.close(context);
        }

        public void write(K arg0, V arg1) throws IOException, InterruptedException {
            this.lineRecordWriter.write(this.getData(arg0), this.getData(arg1));
        }

        private Object getData(Object o) {
            Object data = o;
            if (o instanceof AvroWrapper) {
                data = ((AvroWrapper)o).datum();
            }
            return data;
        }
    }
}

