/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;
import org.apache.crunch.Union;
import org.apache.crunch.fn.CompositeMapFn;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.types.CollectionDeepCopier;
import org.apache.crunch.types.MapDeepCopier;
import org.apache.crunch.types.NoOpDeepCopier;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypes;
import org.apache.crunch.types.TupleDeepCopier;
import org.apache.crunch.types.TupleFactory;
import org.apache.crunch.types.UnionDeepCopier;
import org.apache.crunch.types.avro.AvroCapabilities;
import org.apache.crunch.types.avro.AvroDeepCopier;
import org.apache.crunch.types.avro.AvroDerivedValueDeepCopier;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroTableType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.avro.ReflectDataFactory;
import org.apache.crunch.types.writable.WritableDeepCopier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.ReflectionUtils;

public class Avros {
    public static final boolean CAN_COMBINE_SPECIFIC_AND_REFLECT_SCHEMAS = AvroCapabilities.canDecodeSpecificSchemaWithReflectDatumReader();
    public static ReflectDataFactory REFLECT_DATA_FACTORY = new ReflectDataFactory();
    public static final String REFLECT_DATA_FACTORY_CLASS = "crunch.reflectdatafactory";
    public static MapFn<CharSequence, String> UTF8_TO_STRING = new MapFn<CharSequence, String>(){

        @Override
        public String map(CharSequence input) {
            return ((Object)input).toString();
        }
    };
    public static MapFn<String, Utf8> STRING_TO_UTF8 = new MapFn<String, Utf8>(){

        @Override
        public Utf8 map(String input) {
            return new Utf8(input);
        }
    };
    public static MapFn<Object, ByteBuffer> BYTES_IN = new MapFn<Object, ByteBuffer>(){

        @Override
        public ByteBuffer map(Object input) {
            if (input instanceof ByteBuffer) {
                return (ByteBuffer)input;
            }
            return ByteBuffer.wrap((byte[])input);
        }
    };
    private static final AvroType<String> strings = new AvroType<String>(String.class, Schema.create((Schema.Type)Schema.Type.STRING), UTF8_TO_STRING, STRING_TO_UTF8, NoOpDeepCopier.create(), AvroType.AvroRecordType.GENERIC, new PType[0]);
    private static final AvroType<Void> nulls = Avros.create(Void.class, Schema.Type.NULL);
    private static final AvroType<Long> longs = Avros.create(Long.class, Schema.Type.LONG);
    private static final AvroType<Integer> ints = Avros.create(Integer.class, Schema.Type.INT);
    private static final AvroType<Float> floats = Avros.create(Float.class, Schema.Type.FLOAT);
    private static final AvroType<Double> doubles = Avros.create(Double.class, Schema.Type.DOUBLE);
    private static final AvroType<Boolean> booleans = Avros.create(Boolean.class, Schema.Type.BOOLEAN);
    private static final AvroType<ByteBuffer> bytes = new AvroType<ByteBuffer>(ByteBuffer.class, Schema.create((Schema.Type)Schema.Type.BYTES), BYTES_IN, IdentityFn.getInstance(), AvroDeepCopier.AvroByteBufferDeepCopier.INSTANCE, AvroType.AvroRecordType.GENERIC, new PType[0]);
    private static final Map<Class<?>, PType<?>> PRIMITIVES = ImmutableMap.builder().put(String.class, strings).put(Long.class, longs).put(Integer.class, ints).put(Float.class, floats).put(Double.class, doubles).put(Boolean.class, booleans).put(ByteBuffer.class, bytes).build();
    private static final Map<Class<?>, AvroType<?>> EXTENSIONS = Maps.newHashMap();
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);

    @Deprecated
    public static void configureReflectDataFactory(Configuration conf) {
        AvroMode.REFLECT.withFactory(REFLECT_DATA_FACTORY).configure(conf);
    }

    public static ReflectDataFactory getReflectDataFactory(Configuration conf) {
        return (ReflectDataFactory)AvroMode.REFLECT.withFactoryFromConfiguration(conf).getFactory();
    }

    public static void checkCombiningSpecificAndReflectionSchemas() {
        if (!CAN_COMBINE_SPECIFIC_AND_REFLECT_SCHEMAS) {
            throw new IllegalStateException("Crunch does not support running jobs that contain a mixture of reflection-based and avro-generated data types. Please consider turning your reflection-based type into an avro-generated type and using that generated type instead. If the version of Avro you are using is 1.7.0 or greater, you can enable combined schemas by setting the Avros.CAN_COMBINE_SPECIFIC_AND_REFLECT_SCHEMAS field to 'true'.");
        }
    }

    public static <T> DatumReader<T> newReader(Schema schema) {
        return AvroMode.GENERIC.getReader(schema);
    }

    public static <T> DatumReader<T> newReader(AvroType<T> type) {
        return AvroMode.fromType(type).getReader(type.getSchema());
    }

    public static <T> DatumWriter<T> newWriter(Schema schema) {
        return AvroMode.GENERIC.getWriter(schema);
    }

    public static <T> DatumWriter<T> newWriter(AvroType<T> type) {
        return AvroMode.fromType(type).getWriter(type.getSchema());
    }

    public static <T> void register(Class<T> clazz, AvroType<T> ptype) {
        EXTENSIONS.put(clazz, ptype);
    }

    public static <T> PType<T> getPrimitiveType(Class<T> clazz) {
        return PRIMITIVES.get(clazz);
    }

    static <T> boolean isPrimitive(AvroType<T> avroType) {
        return avroType.getTypeClass().isPrimitive() || PRIMITIVES.containsKey(avroType.getTypeClass());
    }

    static <T> boolean isPrimitive(Class<T> typeClass) {
        return typeClass.isPrimitive() || PRIMITIVES.containsKey(typeClass);
    }

    private static <T> AvroType<T> create(Class<T> clazz, Schema.Type schemaType) {
        return new AvroType<T>(clazz, Schema.create((Schema.Type)schemaType), NoOpDeepCopier.create(), new PType[0]);
    }

    public static final AvroType<Void> nulls() {
        return nulls;
    }

    public static final AvroType<String> strings() {
        return strings;
    }

    public static final AvroType<Long> longs() {
        return longs;
    }

    public static final AvroType<Integer> ints() {
        return ints;
    }

    public static final AvroType<Float> floats() {
        return floats;
    }

    public static final AvroType<Double> doubles() {
        return doubles;
    }

    public static final AvroType<Boolean> booleans() {
        return booleans;
    }

    public static final AvroType<ByteBuffer> bytes() {
        return bytes;
    }

    public static final <T> AvroType<T> records(Class<T> clazz) {
        if (EXTENSIONS.containsKey(clazz)) {
            return EXTENSIONS.get(clazz);
        }
        return Avros.containers(clazz);
    }

    public static final AvroType<GenericData.Record> generics(Schema schema) {
        return new AvroType<GenericData.Record>(GenericData.Record.class, schema, new AvroDeepCopier.AvroGenericDeepCopier(schema), new PType[0]);
    }

    public static final <T> AvroType<T> containers(Class<T> clazz) {
        if (SpecificRecord.class.isAssignableFrom(clazz)) {
            return Avros.specifics(clazz);
        }
        return Avros.reflects(clazz);
    }

    public static final <T extends SpecificRecord> AvroType<T> specifics(Class<T> clazz) {
        SpecificRecord t = (SpecificRecord)ReflectionUtils.newInstance(clazz, null);
        Schema schema = t.getSchema();
        return new AvroType<T>(clazz, schema, new AvroDeepCopier.AvroSpecificDeepCopier<T>(clazz, schema), new PType[0]);
    }

    public static final <T> AvroType<T> reflects(Class<T> clazz) {
        Schema schema = ((ReflectData)AvroMode.REFLECT.getData()).getSchema(clazz);
        return Avros.reflects(clazz, schema);
    }

    public static final <T> AvroType<T> reflects(Class<T> clazz, Schema schema) {
        return new AvroType<T>(clazz, schema, new AvroDeepCopier.AvroReflectDeepCopier<T>(clazz, schema), new PType[0]);
    }

    public static final <T extends Writable> AvroType<T> writables(Class<T> clazz) {
        return new AvroType<T>(clazz, Schema.create((Schema.Type)Schema.Type.BYTES), new BytesToWritableMapFn<T>(clazz), new WritableToBytesMapFn(), new WritableDeepCopier<T>(clazz), AvroType.AvroRecordType.GENERIC, new PType[0]);
    }

    public static final <T> AvroType<Collection<T>> collections(PType<T> ptype) {
        AvroType avroType = (AvroType)ptype;
        Schema collectionSchema = Schema.createArray((Schema)Avros.allowNulls(avroType.getSchema()));
        GenericDataArrayToCollection input = new GenericDataArrayToCollection(avroType.getInputMapFn());
        CollectionToGenericDataArray output = new CollectionToGenericDataArray(collectionSchema, avroType.getOutputMapFn());
        return new AvroType<Collection<T>>(Collection.class, collectionSchema, input, output, new CollectionDeepCopier<T>(ptype), avroType.getRecordType(), ptype);
    }

    public static final <T> AvroType<Map<String, T>> maps(PType<T> ptype) {
        AvroType avroType = (AvroType)ptype;
        Schema mapSchema = Schema.createMap((Schema)Avros.allowNulls(avroType.getSchema()));
        AvroMapToMap inputFn = new AvroMapToMap(avroType.getInputMapFn());
        MapToAvroMap outputFn = new MapToAvroMap(avroType.getOutputMapFn());
        return new AvroType<Map<String, T>>(Map.class, mapSchema, inputFn, outputFn, new MapDeepCopier<T>(ptype), avroType.getRecordType(), ptype);
    }

    public static final <V1, V2> AvroType<Pair<V1, V2>> pairs(PType<V1> p1, PType<V2> p2) {
        Schema schema = Avros.createTupleSchema(p1, p2);
        GenericRecordToTuple input = new GenericRecordToTuple(TupleFactory.PAIR, p1, p2);
        TupleToGenericRecord output = new TupleToGenericRecord(schema, p1, p2);
        return new AvroType<Pair<V1, V2>>(Pair.class, schema, input, output, new TupleDeepCopier<Pair>(Pair.class, p1, p2), null, p1, p2);
    }

    public static final <V1, V2, V3> AvroType<Tuple3<V1, V2, V3>> triples(PType<V1> p1, PType<V2> p2, PType<V3> p3) {
        Schema schema = Avros.createTupleSchema(p1, p2, p3);
        return new AvroType<Tuple3<V1, V2, V3>>(Tuple3.class, schema, new GenericRecordToTuple(TupleFactory.TUPLE3, p1, p2, p3), new TupleToGenericRecord(schema, p1, p2, p3), new TupleDeepCopier<Tuple3>(Tuple3.class, p1, p2, p3), null, p1, p2, p3);
    }

    public static final <V1, V2, V3, V4> AvroType<Tuple4<V1, V2, V3, V4>> quads(PType<V1> p1, PType<V2> p2, PType<V3> p3, PType<V4> p4) {
        Schema schema = Avros.createTupleSchema(p1, p2, p3, p4);
        return new AvroType<Tuple4<V1, V2, V3, V4>>(Tuple4.class, schema, new GenericRecordToTuple(TupleFactory.TUPLE4, p1, p2, p3, p4), new TupleToGenericRecord(schema, p1, p2, p3, p4), new TupleDeepCopier<Tuple4>(Tuple4.class, p1, p2, p3, p4), null, p1, p2, p3, p4);
    }

    public static final AvroType<TupleN> tuples(PType ... ptypes) {
        Schema schema = Avros.createTupleSchema(ptypes);
        return new AvroType<TupleN>(TupleN.class, schema, new GenericRecordToTuple(TupleFactory.TUPLEN, ptypes), new TupleToGenericRecord(schema, ptypes), new TupleDeepCopier<TupleN>(TupleN.class, ptypes), null, ptypes);
    }

    public static <T extends Tuple> AvroType<T> tuples(Class<T> clazz, PType ... ptypes) {
        Schema schema = Avros.createTupleSchema(ptypes);
        Class[] typeArgs = new Class[ptypes.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            typeArgs[i] = ptypes[i].getTypeClass();
        }
        TupleFactory<T> factory = TupleFactory.create(clazz, typeArgs);
        return new AvroType<T>(clazz, schema, new GenericRecordToTuple(factory, ptypes), new TupleToGenericRecord(schema, ptypes), new TupleDeepCopier<T>(clazz, ptypes), null, ptypes);
    }

    public static PType<Union> unionOf(PType<?> ... ptypes) {
        Schema schema;
        MessageDigest md;
        ArrayList schemas = Lists.newArrayList();
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < ptypes.length; ++i) {
            AvroType atype = (AvroType)ptypes[i];
            schema = atype.getSchema();
            if (schemas.contains(schema)) continue;
            schemas.add(schema);
            md.update(schema.toString().getBytes(Charsets.UTF_8));
        }
        ArrayList fields = Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("index", Schema.create((Schema.Type)Schema.Type.INT), "", null), new Schema.Field("value", Schema.createUnion((List)schemas), "", null)});
        String schemaName = "union" + Base64.encodeBase64URLSafeString((byte[])md.digest()).replace('-', 'x');
        schema = Schema.createRecord((String)schemaName, (String)"", (String)"crunch", (boolean)false);
        schema.setFields((List)fields);
        return new AvroType<Union>(Union.class, schema, new UnionRecordToTuple(ptypes), new TupleToUnionRecord(schema, ptypes), new UnionDeepCopier(ptypes), null, (PType[])ptypes);
    }

    private static Schema createTupleSchema(PType<?> ... ptypes) throws RuntimeException {
        MessageDigest md;
        ArrayList fields = Lists.newArrayList();
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < ptypes.length; ++i) {
            AvroType atype = (AvroType)ptypes[i];
            Schema fieldSchema = Avros.allowNulls(atype.getSchema());
            fields.add(new Schema.Field("v" + i, fieldSchema, "", null));
            md.update(fieldSchema.toString().getBytes(Charsets.UTF_8));
        }
        String schemaName = "tuple" + Base64.encodeBase64URLSafeString((byte[])md.digest()).replace('-', 'x');
        Schema schema = Schema.createRecord((String)schemaName, (String)"", (String)"crunch", (boolean)false);
        schema.setFields((List)fields);
        return schema;
    }

    public static final <S, T> AvroType<T> derived(Class<T> clazz, MapFn<S, T> inputFn, MapFn<T, S> outputFn, PType<S> base) {
        AvroType abase = (AvroType)base;
        return new AvroType<T>(clazz, abase.getSchema(), new CompositeMapFn(abase.getInputMapFn(), inputFn), new CompositeMapFn<T, S, Object>(outputFn, abase.getOutputMapFn()), new AvroDerivedValueDeepCopier<T, S>(outputFn, inputFn, abase), abase.getRecordType(), base.getSubTypes().toArray(new PType[0]));
    }

    public static final <S, T> AvroType<T> derivedImmutable(Class<T> clazz, MapFn<S, T> inputFn, MapFn<T, S> outputFn, PType<S> base) {
        AvroType abase = (AvroType)base;
        return new AvroType<T>(clazz, abase.getSchema(), new CompositeMapFn(abase.getInputMapFn(), inputFn), new CompositeMapFn<T, S, Object>(outputFn, abase.getOutputMapFn()), NoOpDeepCopier.create(), abase.getRecordType(), base.getSubTypes().toArray(new PType[0]));
    }

    public static <T> PType<T> jsons(Class<T> clazz) {
        return PTypes.jsonString(clazz, AvroTypeFamily.getInstance());
    }

    public static final <K, V> AvroTableType<K, V> tableOf(PType<K> key, PType<V> value) {
        PTableType ptt;
        if (key instanceof PTableType) {
            ptt = (PTableType)key;
            key = Avros.pairs(ptt.getKeyType(), ptt.getValueType());
        }
        if (value instanceof PTableType) {
            ptt = (PTableType)value;
            value = Avros.pairs(ptt.getKeyType(), ptt.getValueType());
        }
        AvroType avroKey = (AvroType)key;
        AvroType avroValue = (AvroType)value;
        return new AvroTableType(avroKey, avroValue, Pair.class);
    }

    private static Schema allowNulls(Schema base) {
        if (NULL_SCHEMA.equals((Object)base)) {
            return base;
        }
        return Schema.createUnion((List)ImmutableList.of((Object)base, (Object)NULL_SCHEMA));
    }

    private static int reflectAwareHashCode(Object o, Schema s, AvroMode mode) {
        if (o == null) {
            return 0;
        }
        int hashCode = 1;
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field f : s.getFields()) {
                    if (f.order() == Schema.Field.Order.IGNORE) continue;
                    hashCode = Avros.hashCodeAdd(hashCode, mode.getData().getField(o, f.name(), f.pos()), f.schema(), mode);
                }
                return hashCode;
            }
            case ARRAY: {
                Collection a = (Collection)o;
                Schema elementType = s.getElementType();
                for (Object e : a) {
                    hashCode = Avros.hashCodeAdd(hashCode, e, elementType, mode);
                }
                return hashCode;
            }
            case UNION: {
                return Avros.reflectAwareHashCode(o, (Schema)s.getTypes().get(mode.getData().resolveUnion(s, o)), mode);
            }
            case ENUM: {
                return s.getEnumOrdinal(o.toString());
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                return (o instanceof Utf8 ? o : new Utf8(o.toString())).hashCode();
            }
        }
        return o.hashCode();
    }

    private static int hashCodeAdd(int hashCode, Object o, Schema s, AvroMode mode) {
        return 31 * hashCode + Avros.reflectAwareHashCode(o, s, mode);
    }

    private Avros() {
    }

    private static class ReflectGenericRecord
    extends GenericData.Record {
        private AvroMode mode;

        public ReflectGenericRecord(Schema schema, AvroMode mode) {
            super(schema);
            this.mode = mode;
        }

        public int hashCode() {
            return Avros.reflectAwareHashCode((Object)this, this.getSchema(), this.mode);
        }
    }

    private static class TupleToUnionRecord
    extends MapFn<Union, GenericRecord> {
        private final List<MapFn> fns = Lists.newArrayList();
        private final List<AvroType> avroTypes = Lists.newArrayList();
        private final String jsonSchema;
        private final boolean isReflect;
        private transient Schema schema;
        private transient AvroMode mode;

        public TupleToUnionRecord(Schema schema, PType<?> ... ptypes) {
            this.jsonSchema = schema.toString();
            boolean reflectFound = false;
            boolean specificFound = false;
            for (PType<?> ptype : ptypes) {
                AvroType atype = (AvroType)ptype;
                this.fns.add(atype.getOutputMapFn());
                this.avroTypes.add(atype);
                if (atype.hasReflect()) {
                    reflectFound = true;
                }
                if (!atype.hasSpecific()) continue;
                specificFound = true;
            }
            if (specificFound && reflectFound) {
                Avros.checkCombiningSpecificAndReflectionSchemas();
            }
            this.isReflect = reflectFound;
        }

        @Override
        public void configure(Configuration conf) {
            for (MapFn fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (MapFn fn : this.fns) {
                fn.setContext(this.getContext());
            }
        }

        @Override
        public void initialize() {
            this.schema = new Schema.Parser().parse(this.jsonSchema);
            for (MapFn fn : this.fns) {
                fn.initialize();
            }
            this.mode = this.getConfiguration() != null ? AvroMode.REFLECT.withFactoryFromConfiguration(this.getConfiguration()) : AvroMode.REFLECT;
        }

        private GenericRecord createRecord() {
            if (this.isReflect) {
                return new ReflectGenericRecord(this.schema, this.mode);
            }
            return new GenericData.Record(this.schema);
        }

        @Override
        public GenericRecord map(Union input) {
            GenericRecord record = this.createRecord();
            int index = input.getIndex();
            record.put(0, (Object)index);
            record.put(1, this.fns.get(index).map(input.getValue()));
            return record;
        }
    }

    private static class UnionRecordToTuple
    extends MapFn<GenericRecord, Union> {
        private final List<MapFn> fns = Lists.newArrayList();

        public UnionRecordToTuple(PType<?> ... ptypes) {
            for (PType<?> ptype : ptypes) {
                AvroType atype = (AvroType)ptype;
                this.fns.add(atype.getInputMapFn());
            }
        }

        @Override
        public void configure(Configuration conf) {
            for (MapFn fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (MapFn fn : this.fns) {
                fn.setContext(context);
            }
        }

        @Override
        public void initialize() {
            for (MapFn fn : this.fns) {
                fn.initialize();
            }
        }

        @Override
        public Union map(GenericRecord input) {
            int index = (Integer)input.get(0);
            return new Union(index, this.fns.get(index).map(input.get(1)));
        }
    }

    private static class TupleToGenericRecord
    extends MapFn<Tuple, GenericRecord> {
        private final List<MapFn> fns = Lists.newArrayList();
        private final List<AvroType> avroTypes = Lists.newArrayList();
        private final String jsonSchema;
        private final boolean isReflect;
        private transient Schema schema;
        private transient AvroMode mode;

        public TupleToGenericRecord(Schema schema, PType<?> ... ptypes) {
            this.jsonSchema = schema.toString();
            boolean reflectFound = false;
            boolean specificFound = false;
            for (PType<?> ptype : ptypes) {
                AvroType atype = (AvroType)ptype;
                this.fns.add(atype.getOutputMapFn());
                this.avroTypes.add(atype);
                if (atype.hasReflect()) {
                    reflectFound = true;
                }
                if (!atype.hasSpecific()) continue;
                specificFound = true;
            }
            if (specificFound && reflectFound) {
                Avros.checkCombiningSpecificAndReflectionSchemas();
            }
            this.isReflect = reflectFound;
        }

        @Override
        public void configure(Configuration conf) {
            for (MapFn fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (MapFn fn : this.fns) {
                fn.setContext(this.getContext());
            }
        }

        @Override
        public void initialize() {
            this.schema = new Schema.Parser().parse(this.jsonSchema);
            for (MapFn fn : this.fns) {
                fn.initialize();
            }
            this.mode = this.getConfiguration() != null ? AvroMode.REFLECT.withFactoryFromConfiguration(this.getConfiguration()) : AvroMode.REFLECT;
        }

        private GenericRecord createRecord() {
            if (this.isReflect) {
                return new ReflectGenericRecord(this.schema, this.mode);
            }
            return new GenericData.Record(this.schema);
        }

        @Override
        public GenericRecord map(Tuple input) {
            GenericRecord record = this.createRecord();
            for (int i = 0; i < input.size(); ++i) {
                Object v = input.get(i);
                if (v == null) {
                    record.put(i, null);
                    continue;
                }
                record.put(i, this.fns.get(i).map(v));
            }
            return record;
        }
    }

    private static class GenericRecordToTuple
    extends MapFn<GenericRecord, Tuple> {
        private final TupleFactory<?> tupleFactory;
        private final List<MapFn> fns;
        private transient Object[] values;

        public GenericRecordToTuple(TupleFactory<?> tupleFactory, PType<?> ... ptypes) {
            this.tupleFactory = tupleFactory;
            this.fns = Lists.newArrayList();
            for (PType<?> ptype : ptypes) {
                AvroType atype = (AvroType)ptype;
                this.fns.add(atype.getInputMapFn());
            }
        }

        @Override
        public void configure(Configuration conf) {
            for (MapFn fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (MapFn fn : this.fns) {
                fn.setContext(context);
            }
        }

        @Override
        public void initialize() {
            for (MapFn fn : this.fns) {
                fn.initialize();
            }
            this.values = new Object[this.fns.size()];
            this.tupleFactory.initialize();
        }

        @Override
        public Tuple map(GenericRecord input) {
            for (int i = 0; i < this.values.length; ++i) {
                Object v = input.get(i);
                this.values[i] = v == null ? null : this.fns.get(i).map(v);
            }
            return this.tupleFactory.makeTuple(this.values);
        }
    }

    private static class MapToAvroMap<T>
    extends MapFn<Map<String, T>, Map<Utf8, Object>> {
        private final MapFn<T, Object> mapFn;

        public MapToAvroMap(MapFn<T, Object> mapFn) {
            this.mapFn = mapFn;
        }

        @Override
        public void configure(Configuration conf) {
            this.mapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.mapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.mapFn.initialize();
        }

        @Override
        public Map<Utf8, Object> map(Map<String, T> input) {
            HashMap out = Maps.newHashMap();
            for (Map.Entry<String, T> e : input.entrySet()) {
                out.put(new Utf8(e.getKey()), this.mapFn.map(e.getValue()));
            }
            return out;
        }
    }

    private static class AvroMapToMap<T>
    extends MapFn<Map<CharSequence, Object>, Map<String, T>> {
        private final MapFn<Object, T> mapFn;

        public AvroMapToMap(MapFn<Object, T> mapFn) {
            this.mapFn = mapFn;
        }

        @Override
        public void configure(Configuration conf) {
            this.mapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.mapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.mapFn.initialize();
        }

        @Override
        public Map<String, T> map(Map<CharSequence, Object> input) {
            HashMap out = Maps.newHashMap();
            for (Map.Entry<CharSequence, Object> e : input.entrySet()) {
                out.put(((Object)e.getKey()).toString(), this.mapFn.map(e.getValue()));
            }
            return out;
        }
    }

    private static class CollectionToGenericDataArray
    extends MapFn<Collection<?>, GenericData.Array<?>> {
        private final MapFn mapFn;
        private final String jsonSchema;
        private transient Schema schema;

        public CollectionToGenericDataArray(Schema schema, MapFn mapFn) {
            this.mapFn = mapFn;
            this.jsonSchema = schema.toString();
        }

        @Override
        public void configure(Configuration conf) {
            this.mapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.mapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.mapFn.initialize();
        }

        @Override
        public GenericData.Array<?> map(Collection<?> input) {
            if (this.schema == null) {
                this.schema = new Schema.Parser().parse(this.jsonSchema);
            }
            GenericData.Array array = new GenericData.Array(input.size(), this.schema);
            for (Object in : input) {
                array.add(this.mapFn.map(in));
            }
            return array;
        }
    }

    private static class GenericDataArrayToCollection<T>
    extends MapFn<Object, Collection<T>> {
        private final MapFn<Object, T> mapFn;

        public GenericDataArrayToCollection(MapFn<Object, T> mapFn) {
            this.mapFn = mapFn;
        }

        @Override
        public void configure(Configuration conf) {
            this.mapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.mapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.mapFn.initialize();
        }

        @Override
        public Collection<T> map(Object input) {
            ArrayList ret = Lists.newArrayList();
            if (input instanceof Collection) {
                for (Object in : (Collection)input) {
                    ret.add(this.mapFn.map(in));
                }
            } else {
                Object[] arr;
                for (Object in : arr = (Object[])input) {
                    ret.add(this.mapFn.map(in));
                }
            }
            return ret;
        }
    }

    private static class WritableToBytesMapFn<T extends Writable>
    extends MapFn<T, ByteBuffer> {
        private static final Log LOG = LogFactory.getLog(WritableToBytesMapFn.class);

        private WritableToBytesMapFn() {
        }

        @Override
        public ByteBuffer map(T input) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(baos);
            try {
                input.write((DataOutput)das);
            }
            catch (IOException e) {
                LOG.error((Object)"Exception thrown converting Writable to bytes", (Throwable)e);
            }
            return ByteBuffer.wrap(baos.toByteArray());
        }
    }

    private static class BytesToWritableMapFn<T extends Writable>
    extends MapFn<Object, T> {
        private static final Log LOG = LogFactory.getLog(BytesToWritableMapFn.class);
        private final Class<T> writableClazz;

        public BytesToWritableMapFn(Class<T> writableClazz) {
            this.writableClazz = writableClazz;
        }

        @Override
        public T map(Object input) {
            ByteBuffer byteBuffer = BYTES_IN.map(input);
            Writable instance = (Writable)ReflectionUtils.newInstance(this.writableClazz, null);
            try {
                instance.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit())));
            }
            catch (IOException e) {
                LOG.error((Object)("Exception thrown reading instance of: " + this.writableClazz), (Throwable)e);
            }
            return (T)instance;
        }
    }
}

