/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.types.DeepCopier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;

public class WritableDeepCopier<T extends Writable>
implements DeepCopier<T> {
    private Class<T> writableClass;

    public WritableDeepCopier(Class<T> writableClass) {
        this.writableClass = writableClass;
    }

    @Override
    public void initialize(Configuration conf) {
    }

    @Override
    public T deepCopy(T source) {
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOutStream);
        Writable copiedValue = null;
        try {
            source.write((DataOutput)dataOut);
            dataOut.flush();
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
            DataInputStream dataInput = new DataInputStream(byteInStream);
            copiedValue = (Writable)this.writableClass.newInstance();
            copiedValue.readFields((DataInput)dataInput);
        }
        catch (Exception e) {
            throw new CrunchRuntimeException("Error while deep copying " + source, e);
        }
        return (T)copiedValue;
    }
}

