/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.writable.WritablePairConverter;
import org.apache.crunch.types.writable.WritableTableType;
import org.apache.crunch.types.writable.WritableType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

class WritableGroupedTableType<K, V>
extends PGroupedTableType<K, V> {
    private final MapFn inputFn;
    private final MapFn outputFn;
    private final Converter converter;

    WritableGroupedTableType(WritableTableType<K, V> tableType) {
        super(tableType);
        WritableType keyType = (WritableType)tableType.getKeyType();
        WritableType valueType = (WritableType)tableType.getValueType();
        this.inputFn = new PGroupedTableType.PairIterableMapFn(keyType.getInputMapFn(), valueType.getInputMapFn());
        this.outputFn = tableType.getOutputMapFn();
        this.converter = new WritablePairConverter(keyType.getSerializationClass(), valueType.getSerializationClass());
    }

    @Override
    public Class<Pair<K, Iterable<V>>> getTypeClass() {
        return Pair.of(null, null).getClass();
    }

    @Override
    public Converter getGroupingConverter() {
        return this.converter;
    }

    @Override
    public MapFn getInputMapFn() {
        return this.inputFn;
    }

    @Override
    public MapFn getOutputMapFn() {
        return this.outputFn;
    }

    @Override
    public void initialize(Configuration conf) {
        this.tableType.initialize(conf);
    }

    @Override
    public Pair<K, Iterable<V>> getDetachedValue(Pair<K, Iterable<V>> value) {
        return PTables.getGroupedDetachedValue(this, value);
    }

    @Override
    public void configureShuffle(Job job, GroupingOptions options) {
        if (options != null) {
            options.configure(job);
        }
        WritableType keyType = (WritableType)this.tableType.getKeyType();
        WritableType valueType = (WritableType)this.tableType.getValueType();
        job.setMapOutputKeyClass(keyType.getSerializationClass());
        job.setMapOutputValueClass(valueType.getSerializationClass());
    }
}

