/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import org.apache.crunch.Pair;
import org.apache.crunch.types.Converter;

class WritablePairConverter<K, V>
implements Converter<K, V, Pair<K, V>, Pair<K, Iterable<V>>> {
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    public WritablePairConverter(Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public Pair<K, V> convertInput(K key, V value) {
        return Pair.of(key, value);
    }

    @Override
    public K outputKey(Pair<K, V> value) {
        return value.first();
    }

    @Override
    public V outputValue(Pair<K, V> value) {
        return value.second();
    }

    @Override
    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean applyPTypeTransforms() {
        return true;
    }

    @Override
    public Pair<K, Iterable<V>> convertIterableInput(K key, Iterable<V> value) {
        return Pair.of(key, value);
    }
}

