/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.MapFn;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.io.seq.SeqFileSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.writable.WritableDeepCopier;
import org.apache.crunch.types.writable.WritableTypeFamily;
import org.apache.crunch.types.writable.WritableValueConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public class WritableType<T, W extends Writable>
implements PType<T> {
    private final Class<T> typeClass;
    private final Class<W> writableClass;
    private final Converter converter;
    private final MapFn<W, T> inputFn;
    private final MapFn<T, W> outputFn;
    private final DeepCopier<W> deepCopier;
    private final List<PType> subTypes;
    private boolean initialized = false;

    public static <T, W extends Writable> WritableType<T, W> immutableType(Class<T> typeClass, Class<W> writableClass, MapFn<W, T> inputDoFn, MapFn<T, W> outputDoFn, PType ... subTypes) {
        return new WritableType<T, W>(typeClass, writableClass, inputDoFn, outputDoFn, null, subTypes);
    }

    public WritableType(Class<T> typeClass, Class<W> writableClass, MapFn<W, T> inputDoFn, MapFn<T, W> outputDoFn, PType ... subTypes) {
        this(typeClass, writableClass, inputDoFn, outputDoFn, new WritableDeepCopier<W>(writableClass), subTypes);
    }

    private WritableType(Class<T> typeClass, Class<W> writableClass, MapFn<W, T> inputDoFn, MapFn<T, W> outputDoFn, DeepCopier<W> deepCopier, PType ... subTypes) {
        this.typeClass = typeClass;
        this.writableClass = writableClass;
        this.inputFn = inputDoFn;
        this.outputFn = outputDoFn;
        this.converter = new WritableValueConverter<W>(writableClass);
        this.deepCopier = deepCopier;
        this.subTypes = ImmutableList.builder().add((Object[])subTypes).build();
    }

    @Override
    public PTypeFamily getFamily() {
        return WritableTypeFamily.getInstance();
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public MapFn getInputMapFn() {
        return this.inputFn;
    }

    @Override
    public MapFn getOutputMapFn() {
        return this.outputFn;
    }

    @Override
    public List<PType> getSubTypes() {
        return this.subTypes;
    }

    public Class<W> getSerializationClass() {
        return this.writableClass;
    }

    @Override
    public ReadableSourceTarget<T> getDefaultFileSource(Path path) {
        return new SeqFileSourceTarget(path, this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WritableType)) {
            return false;
        }
        WritableType wt = (WritableType)obj;
        return this.typeClass.equals(wt.typeClass) && this.writableClass.equals(wt.writableClass) && ((Object)this.subTypes).equals(wt.subTypes);
    }

    @Override
    public void initialize(Configuration conf) {
        this.inputFn.setConfiguration(conf);
        this.outputFn.setConfiguration(conf);
        this.inputFn.initialize();
        this.outputFn.initialize();
        for (PType subType : this.subTypes) {
            subType.initialize(conf);
        }
        this.initialized = true;
    }

    @Override
    public T getDetachedValue(T value) {
        if (this.deepCopier == null) {
            return value;
        }
        if (!this.initialized) {
            throw new IllegalStateException("Cannot call getDetachedValue on an uninitialized PType");
        }
        Writable writableValue = (Writable)this.outputFn.map(value);
        Writable deepCopy = this.deepCopier.deepCopy(writableValue);
        return this.inputFn.map(deepCopy);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.typeClass).append(this.writableClass).append(this.subTypes);
        return hcb.toHashCode();
    }
}

