/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.crunch.DoFn;
import org.apache.crunch.ReadableData;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.util.DoFnIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class DelegatingReadableData<S, T>
implements ReadableData<T> {
    private final ReadableData<S> delegate;
    private final DoFn<S, T> fn;

    public DelegatingReadableData(ReadableData<S> delegate, DoFn<S, T> fn) {
        this.delegate = delegate;
        this.fn = fn;
    }

    @Override
    public Set<SourceTarget<?>> getSourceTargets() {
        return this.delegate.getSourceTargets();
    }

    @Override
    public void configure(Configuration conf) {
        this.delegate.configure(conf);
        this.fn.configure(conf);
    }

    @Override
    public Iterable<T> read(TaskInputOutputContext<?, ?, ?, ?> context) throws IOException {
        this.fn.setContext(context);
        this.fn.initialize();
        final Iterable<S> delegateIterable = this.delegate.read(context);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new DoFnIterator(delegateIterable.iterator(), DelegatingReadableData.this.fn);
            }
        };
    }
}

