/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.crunch.ReadableData;
import org.apache.crunch.SourceTarget;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class UnionReadableData<T>
implements ReadableData<T> {
    private final List<ReadableData<T>> data;

    public UnionReadableData(List<ReadableData<T>> data) {
        this.data = data;
    }

    @Override
    public Set<SourceTarget<?>> getSourceTargets() {
        HashSet srcTargets = Sets.newHashSet();
        for (ReadableData<T> rd : this.data) {
            srcTargets.addAll(rd.getSourceTargets());
        }
        return srcTargets;
    }

    @Override
    public void configure(Configuration conf) {
        for (ReadableData<T> rd : this.data) {
            rd.configure(conf);
        }
    }

    @Override
    public Iterable<T> read(TaskInputOutputContext<?, ?, ?, ?> context) throws IOException {
        ArrayList iterables = Lists.newArrayList();
        for (ReadableData<T> rd : this.data) {
            iterables.add(rd.read(context));
        }
        return Iterables.concat((Iterable)iterables);
    }
}

