/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.PlatformName;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;

public class TestConfiguration
extends TestCase {
    private Configuration conf;
    static final String CONFIG = new File("./test-config-TestConfiguration.xml").getAbsolutePath();
    static final String CONFIG2 = new File("./test-config2-TestConfiguration.xml").getAbsolutePath();
    private static final String CONFIG_MULTI_BYTE = new File("./test-config-multi-byte-TestConfiguration.xml").getAbsolutePath();
    private static final String CONFIG_MULTI_BYTE_SAVED = new File("./test-config-multi-byte-saved-TestConfiguration.xml").getAbsolutePath();
    static final Random RAN = new Random();
    static final String XMLHEADER = PlatformName.IBM_JAVA ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configuration>" : "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><configuration>";
    final String UNSPEC;
    ArrayList<Prop> props = new ArrayList();
    BufferedWriter out;

    public TestConfiguration() {
        this.UNSPEC = null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new Configuration();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        new File(CONFIG).delete();
        new File(CONFIG2).delete();
        new File(CONFIG_MULTI_BYTE).delete();
        new File(CONFIG_MULTI_BYTE_SAVED).delete();
    }

    private void startConfig() throws IOException {
        this.out.write("<?xml version=\"1.0\"?>\n");
        this.out.write("<configuration>\n");
    }

    private void endConfig() throws IOException {
        this.out.write("</configuration>\n");
        this.out.close();
    }

    private void addInclude(String filename) throws IOException {
        this.out.write("<xi:include href=\"" + filename + "\" xmlns:xi=\"http://www.w3.org/2001/XInclude\"  />\n ");
    }

    public void testInputStreamResource() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A");
        this.endConfig();
        ByteArrayInputStream in1 = new ByteArrayInputStream(writer.toString().getBytes());
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)in1);
        TestConfiguration.assertEquals((String)"A", (String)conf.get("prop"));
        ByteArrayInputStream in2 = new ByteArrayInputStream(writer.toString().getBytes());
        conf.addResource((InputStream)in2);
        TestConfiguration.assertEquals((String)"A", (String)conf.get("prop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiByteCharacters() throws IOException {
        String priorDefaultEncoding = System.getProperty("file.encoding");
        try {
            System.setProperty("file.encoding", "US-ASCII");
            String name = "multi_byte_\u611b_name";
            String value = "multi_byte_\u0641_value";
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG_MULTI_BYTE), "UTF-8"));
            this.startConfig();
            this.declareProperty(name, value, value);
            this.endConfig();
            Configuration conf = new Configuration(false);
            conf.addResource(new Path(CONFIG_MULTI_BYTE));
            TestConfiguration.assertEquals((String)value, (String)conf.get(name));
            FileOutputStream fos = new FileOutputStream(CONFIG_MULTI_BYTE_SAVED);
            try {
                conf.writeXml((OutputStream)fos);
            }
            finally {
                IOUtils.closeStream((Closeable)fos);
            }
            conf = new Configuration(false);
            conf.addResource(new Path(CONFIG_MULTI_BYTE_SAVED));
            TestConfiguration.assertEquals((String)value, (String)conf.get(name));
        }
        finally {
            System.setProperty("file.encoding", priorDefaultEncoding);
        }
    }

    public void testVariableSubstitution() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.int", "${intvar}", "42");
        this.declareProperty("intvar", "42", "42");
        this.declareProperty("my.base", "/tmp/${user.name}", this.UNSPEC);
        this.declareProperty("my.file", "hello", "hello");
        this.declareProperty("my.suffix", ".txt", ".txt");
        this.declareProperty("my.relfile", "${my.file}${my.suffix}", "hello.txt");
        this.declareProperty("my.fullfile", "${my.base}/${my.file}${my.suffix}", this.UNSPEC);
        this.declareProperty("my.failsexpand", "a${my.undefvar}b", "a${my.undefvar}b");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        for (Prop p : this.props) {
            System.out.println("p=" + p.name);
            String gotVal = this.conf.get(p.name);
            String gotRawVal = this.conf.getRaw(p.name);
            TestConfiguration.assertEq(p.val, gotRawVal);
            if (p.expectEval == this.UNSPEC) {
                TestConfiguration.assertTrue((gotVal != null && -1 == gotVal.indexOf("${") ? 1 : 0) != 0);
                continue;
            }
            TestConfiguration.assertEq(p.expectEval, gotVal);
        }
        TestConfiguration.assertTrue((this.conf.getInt("intvar", -1) == 42 ? 1 : 0) != 0);
        TestConfiguration.assertTrue((this.conf.getInt("my.int", -1) == 42 ? 1 : 0) != 0);
        Map results = this.conf.getValByRegex("^my.*file$");
        TestConfiguration.assertTrue((boolean)results.keySet().contains("my.relfile"));
        TestConfiguration.assertTrue((boolean)results.keySet().contains("my.fullfile"));
        TestConfiguration.assertTrue((boolean)results.keySet().contains("my.file"));
        TestConfiguration.assertEquals((int)-1, (int)((String)results.get("my.relfile")).indexOf("${"));
        TestConfiguration.assertEquals((int)-1, (int)((String)results.get("my.fullfile")).indexOf("${"));
        TestConfiguration.assertEquals((int)-1, (int)((String)results.get("my.file")).indexOf("${"));
    }

    public void testFinalParam() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.var", "", "", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf1 = new Configuration();
        conf1.addResource(fileResource);
        TestConfiguration.assertNull((String)"my var is not null", (Object)conf1.get("my.var"));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.declareProperty("my.var", "myval", "myval", false);
        this.endConfig();
        fileResource = new Path(CONFIG2);
        Configuration conf2 = new Configuration(conf1);
        conf2.addResource(fileResource);
        TestConfiguration.assertNull((String)"my var is not final", (Object)conf2.get("my.var"));
    }

    public static void assertEq(Object a, Object b) {
        System.out.println("assertEq: " + a + ", " + b);
        TestConfiguration.assertEquals((Object)a, (Object)b);
    }

    void declareProperty(String name, String val, String expectEval) throws IOException {
        this.declareProperty(name, val, expectEval, false);
    }

    void declareProperty(String name, String val, String expectEval, boolean isFinal) throws IOException {
        this.appendProperty(name, val, isFinal, new String[0]);
        Prop p = new Prop();
        p.name = name;
        p.val = val;
        p.expectEval = expectEval;
        this.props.add(p);
    }

    void appendProperty(String name, String val) throws IOException {
        this.appendProperty(name, val, false, new String[0]);
    }

    void appendProperty(String name, String val, boolean isFinal, String ... sources) throws IOException {
        this.out.write("<property>");
        this.out.write("<name>");
        this.out.write(name);
        this.out.write("</name>");
        this.out.write("<value>");
        this.out.write(val);
        this.out.write("</value>");
        if (isFinal) {
            this.out.write("<final>true</final>");
        }
        for (String s : sources) {
            this.out.write("<source>");
            this.out.write(s);
            this.out.write("</source>");
        }
        this.out.write("</property>\n");
    }

    public void testOverlay() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "c");
        this.appendProperty("d", "e");
        this.appendProperty("e", "f", true, new String[0]);
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "d");
        this.appendProperty("e", "e");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.conf.set("c", "d");
        this.conf.set("a", "d");
        Configuration clone = new Configuration(this.conf);
        clone.addResource(new Path(CONFIG2));
        TestConfiguration.assertEquals((String)clone.get("a"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("b"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("c"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("d"), (String)"e");
        TestConfiguration.assertEquals((String)clone.get("e"), (String)"f");
    }

    public void testCommentsInValue() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("my.comment", "this <!--comment here--> contains a comment");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)"this  contains a comment", (String)this.conf.get("my.comment"));
    }

    public void testTrim() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        String[] whitespaces = new String[]{"", " ", "\n", "\t"};
        String[] name = new String[100];
        for (int i = 0; i < name.length; ++i) {
            name[i] = "foo" + i;
            StringBuilder prefix = new StringBuilder();
            StringBuilder postfix = new StringBuilder();
            for (int j = 0; j < 3; ++j) {
                prefix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
                postfix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
            }
            this.appendProperty(prefix + name[i] + postfix, name[i] + ".value");
        }
        this.endConfig();
        this.conf.addResource(new Path(CONFIG));
        for (String n : name) {
            TestConfiguration.assertEquals((String)(n + ".value"), (String)this.conf.get(n));
        }
    }

    public void testGetLocalPath() throws IOException {
        int i;
        Configuration conf = new Configuration();
        Object[] dirs = new String[]{"a", "b", "c"};
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = new Path(System.getProperty("test.build.data"), (String)dirs[i]).toString();
        }
        conf.set("dirs", StringUtils.join((Object[])dirs, (String)","));
        for (i = 0; i < 1000; ++i) {
            String localPath = conf.getLocalPath("dirs", "dir" + i).toString();
            TestConfiguration.assertTrue((String)("Path doesn't end in specified dir: " + localPath), (boolean)localPath.endsWith("dir" + i));
            TestConfiguration.assertFalse((String)("Path has internal whitespace: " + localPath), (boolean)localPath.contains(" "));
        }
    }

    public void testGetFile() throws IOException {
        int i;
        Configuration conf = new Configuration();
        Object[] dirs = new String[]{"a", "b", "c"};
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = new Path(System.getProperty("test.build.data"), (String)dirs[i]).toString();
        }
        conf.set("dirs", StringUtils.join((Object[])dirs, (String)","));
        for (i = 0; i < 1000; ++i) {
            String localPath = conf.getFile("dirs", "dir" + i).toString();
            TestConfiguration.assertTrue((String)("Path doesn't end in specified dir: " + localPath), (boolean)localPath.endsWith("dir" + i));
            TestConfiguration.assertFalse((String)("Path has internal whitespace: " + localPath), (boolean)localPath.contains(" "));
        }
    }

    public void testToString() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        String expectedOutput = "Configuration: core-default.xml, core-site.xml, " + fileResource.toString();
        TestConfiguration.assertEquals((String)expectedOutput, (String)this.conf.toString());
    }

    public void testWriteXml() throws IOException {
        Configuration conf = new Configuration();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        conf.writeXml((OutputStream)baos);
        String result = baos.toString();
        TestConfiguration.assertTrue((String)"Result has proper header", (boolean)result.startsWith(XMLHEADER));
        TestConfiguration.assertTrue((String)"Result has proper footer", (boolean)result.endsWith("</configuration>"));
    }

    public void testIncludes() throws Exception {
        this.tearDown();
        System.out.println("XXX testIncludes");
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("c", "d");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.addInclude(CONFIG2);
        this.appendProperty("e", "f");
        this.appendProperty("g", "h");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)this.conf.get("a"), (String)"b");
        TestConfiguration.assertEquals((String)this.conf.get("c"), (String)"d");
        TestConfiguration.assertEquals((String)this.conf.get("e"), (String)"f");
        TestConfiguration.assertEquals((String)this.conf.get("g"), (String)"h");
        this.tearDown();
    }

    public void testRelativeIncludes() throws Exception {
        this.tearDown();
        String relConfig = new File("./tmp/test-config.xml").getAbsolutePath();
        String relConfig2 = new File("./tmp/test-config2.xml").getAbsolutePath();
        new File(new File(relConfig).getParent()).mkdirs();
        this.out = new BufferedWriter(new FileWriter(relConfig2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(relConfig));
        this.startConfig();
        this.addInclude(new File(relConfig2).getName());
        this.appendProperty("c", "d");
        this.endConfig();
        Path fileResource = new Path(relConfig);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)this.conf.get("a"), (String)"b");
        TestConfiguration.assertEquals((String)this.conf.get("c"), (String)"d");
        new File(relConfig).delete();
        new File(relConfig2).delete();
        new File(new File(relConfig).getParent()).delete();
    }

    public void testIntegerRanges() {
        Configuration conf = new Configuration();
        conf.set("first", "-100");
        conf.set("second", "4-6,9-10,27");
        conf.set("third", "34-");
        Configuration.IntegerRanges range = conf.getRange("first", null);
        System.out.println("first = " + range);
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(0));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(1));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(100));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(101));
        range = conf.getRange("second", null);
        System.out.println("second = " + range);
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(3));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(4));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(6));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(7));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(8));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(9));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(10));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(11));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(26));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(27));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(28));
        range = conf.getRange("third", null);
        System.out.println("third = " + range);
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(33));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(34));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(100000000));
    }

    public void testGetRangeIterator() throws Exception {
        Configuration config = new Configuration(false);
        Configuration.IntegerRanges ranges = config.getRange("Test", "");
        TestConfiguration.assertFalse((String)"Empty range has values", (boolean)ranges.iterator().hasNext());
        ranges = config.getRange("Test", "5");
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(5));
        HashSet<Integer> found = new HashSet<Integer>();
        for (Integer i : ranges) {
            found.add(i);
        }
        TestConfiguration.assertEquals(expected, found);
        ranges = config.getRange("Test", "5-10,13-14");
        expected = new HashSet<Integer>(Arrays.asList(5, 6, 7, 8, 9, 10, 13, 14));
        found = new HashSet();
        for (Integer i : ranges) {
            found.add(i);
        }
        TestConfiguration.assertEquals(expected, found);
        ranges = config.getRange("Test", "8-12, 5- 7");
        expected = new HashSet<Integer>(Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12));
        found = new HashSet();
        for (Integer i : ranges) {
            found.add(i);
        }
        TestConfiguration.assertEquals(expected, found);
    }

    public void testHexValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.hex1", "0x10");
        this.appendProperty("test.hex2", "0xF");
        this.appendProperty("test.hex3", "-0x10");
        this.appendProperty("test.hex4", "-0x10xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((int)16, (int)this.conf.getInt("test.hex1", 0));
        TestConfiguration.assertEquals((long)16L, (long)this.conf.getLong("test.hex1", 0L));
        TestConfiguration.assertEquals((int)15, (int)this.conf.getInt("test.hex2", 0));
        TestConfiguration.assertEquals((long)15L, (long)this.conf.getLong("test.hex2", 0L));
        TestConfiguration.assertEquals((int)-16, (int)this.conf.getInt("test.hex3", 0));
        TestConfiguration.assertEquals((long)-16L, (long)this.conf.getLong("test.hex3", 0L));
        try {
            this.conf.getLong("test.hex4", 0L);
            TestConfiguration.fail((String)"Property had invalid long value, but was read successfully.");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.conf.getInt("test.hex4", 0);
            TestConfiguration.fail((String)"Property had invalid int value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testIntegerValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.int1", "20");
        this.appendProperty("test.int2", "020");
        this.appendProperty("test.int3", "-20");
        this.appendProperty("test.int4", " -20 ");
        this.appendProperty("test.int5", " -20xyz ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((int)20, (int)this.conf.getInt("test.int1", 0));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLong("test.int1", 0L));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLongBytes("test.int1", 0L));
        TestConfiguration.assertEquals((int)20, (int)this.conf.getInt("test.int2", 0));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLong("test.int2", 0L));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLongBytes("test.int2", 0L));
        TestConfiguration.assertEquals((int)-20, (int)this.conf.getInt("test.int3", 0));
        TestConfiguration.assertEquals((long)-20L, (long)this.conf.getLong("test.int3", 0L));
        TestConfiguration.assertEquals((long)-20L, (long)this.conf.getLongBytes("test.int3", 0L));
        TestConfiguration.assertEquals((int)-20, (int)this.conf.getInt("test.int4", 0));
        TestConfiguration.assertEquals((long)-20L, (long)this.conf.getLong("test.int4", 0L));
        TestConfiguration.assertEquals((long)-20L, (long)this.conf.getLongBytes("test.int4", 0L));
        try {
            this.conf.getInt("test.int5", 0);
            TestConfiguration.fail((String)"Property had invalid int value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testHumanReadableValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.humanReadableValue1", "1m");
        this.appendProperty("test.humanReadableValue2", "1M");
        this.appendProperty("test.humanReadableValue5", "1MBCDE");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((long)0x100000L, (long)this.conf.getLongBytes("test.humanReadableValue1", 0L));
        TestConfiguration.assertEquals((long)0x100000L, (long)this.conf.getLongBytes("test.humanReadableValue2", 0L));
        try {
            this.conf.getLongBytes("test.humanReadableValue5", 0L);
            TestConfiguration.fail((String)"Property had invalid human readable value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testBooleanValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.bool1", "true");
        this.appendProperty("test.bool2", "false");
        this.appendProperty("test.bool3", "  true ");
        this.appendProperty("test.bool4", " false ");
        this.appendProperty("test.bool5", "foo");
        this.appendProperty("test.bool6", "TRUE");
        this.appendProperty("test.bool7", "FALSE");
        this.appendProperty("test.bool8", "");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((boolean)true, (boolean)this.conf.getBoolean("test.bool1", false));
        TestConfiguration.assertEquals((boolean)false, (boolean)this.conf.getBoolean("test.bool2", true));
        TestConfiguration.assertEquals((boolean)true, (boolean)this.conf.getBoolean("test.bool3", false));
        TestConfiguration.assertEquals((boolean)false, (boolean)this.conf.getBoolean("test.bool4", true));
        TestConfiguration.assertEquals((boolean)true, (boolean)this.conf.getBoolean("test.bool5", true));
        TestConfiguration.assertEquals((boolean)true, (boolean)this.conf.getBoolean("test.bool6", false));
        TestConfiguration.assertEquals((boolean)false, (boolean)this.conf.getBoolean("test.bool7", true));
        TestConfiguration.assertEquals((boolean)false, (boolean)this.conf.getBoolean("test.bool8", false));
    }

    public void testFloatValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.float1", "3.1415");
        this.appendProperty("test.float2", "003.1415");
        this.appendProperty("test.float3", "-3.1415");
        this.appendProperty("test.float4", " -3.1415 ");
        this.appendProperty("test.float5", "xyz-3.1415xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((Object)Float.valueOf(3.1415f), (Object)Float.valueOf(this.conf.getFloat("test.float1", 0.0f)));
        TestConfiguration.assertEquals((Object)Float.valueOf(3.1415f), (Object)Float.valueOf(this.conf.getFloat("test.float2", 0.0f)));
        TestConfiguration.assertEquals((Object)Float.valueOf(-3.1415f), (Object)Float.valueOf(this.conf.getFloat("test.float3", 0.0f)));
        TestConfiguration.assertEquals((Object)Float.valueOf(-3.1415f), (Object)Float.valueOf(this.conf.getFloat("test.float4", 0.0f)));
        try {
            this.conf.getFloat("test.float5", 0.0f);
            TestConfiguration.fail((String)"Property had invalid float value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testDoubleValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.double1", "3.1415");
        this.appendProperty("test.double2", "003.1415");
        this.appendProperty("test.double3", "-3.1415");
        this.appendProperty("test.double4", " -3.1415 ");
        this.appendProperty("test.double5", "xyz-3.1415xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((Object)3.1415, (Object)this.conf.getDouble("test.double1", 0.0));
        TestConfiguration.assertEquals((Object)3.1415, (Object)this.conf.getDouble("test.double2", 0.0));
        TestConfiguration.assertEquals((Object)-3.1415, (Object)this.conf.getDouble("test.double3", 0.0));
        TestConfiguration.assertEquals((Object)-3.1415, (Object)this.conf.getDouble("test.double4", 0.0));
        try {
            this.conf.getDouble("test.double5", 0.0);
            TestConfiguration.fail((String)"Property had invalid double value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testGetClass() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.class1", "java.lang.Integer");
        this.appendProperty("test.class2", " java.lang.Integer ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)"java.lang.Integer", (String)this.conf.getClass("test.class1", null).getCanonicalName());
        TestConfiguration.assertEquals((String)"java.lang.Integer", (String)this.conf.getClass("test.class2", null).getCanonicalName());
    }

    public void testGetClasses() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.classes1", "java.lang.Integer,java.lang.String");
        this.appendProperty("test.classes2", " java.lang.Integer , java.lang.String ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Object[] expectedNames = new String[]{"java.lang.Integer", "java.lang.String"};
        Class[] defaultClasses = new Class[]{};
        Class[] classes1 = this.conf.getClasses("test.classes1", defaultClasses);
        Class[] classes2 = this.conf.getClasses("test.classes2", defaultClasses);
        Assert.assertArrayEquals((Object[])expectedNames, (Object[])TestConfiguration.extractClassNames(classes1));
        Assert.assertArrayEquals((Object[])expectedNames, (Object[])TestConfiguration.extractClassNames(classes2));
    }

    public void testGetStringCollection() throws IOException {
        Configuration c = new Configuration();
        c.set("x", " a, b\n,\nc ");
        Collection strs = c.getTrimmedStringCollection("x");
        TestConfiguration.assertEquals((int)3, (int)strs.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])strs.toArray(new String[0]));
        strs.add("z");
        strs = c.getStringCollection("does-not-exist");
        TestConfiguration.assertEquals((int)0, (int)strs.size());
        strs.add("z");
    }

    public void testGetTrimmedStringCollection() throws IOException {
        Configuration c = new Configuration();
        c.set("x", "a, b, c");
        Collection strs = c.getStringCollection("x");
        TestConfiguration.assertEquals((int)3, (int)strs.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", " b", " c"}, (Object[])strs.toArray(new String[0]));
        strs.add("z");
        strs = c.getStringCollection("does-not-exist");
        TestConfiguration.assertEquals((int)0, (int)strs.size());
        strs.add("z");
    }

    private static String[] extractClassNames(Class<?>[] classes) {
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classNames.length; ++i) {
            classNames[i] = classes[i].getCanonicalName();
        }
        return classNames;
    }

    public void testEnum() throws IOException {
        Configuration conf = new Configuration();
        conf.setEnum("test.enum", (Enum)Dingo.FOO);
        TestConfiguration.assertSame((Object)((Object)Dingo.FOO), (Object)conf.getEnum("test.enum", (Enum)Dingo.BAR));
        TestConfiguration.assertSame((Object)((Object)Yak.FOO), (Object)conf.getEnum("test.enum", (Enum)Yak.RAB));
        boolean fail = false;
        try {
            conf.setEnum("test.enum", (Enum)Dingo.BAR);
            Yak y = (Yak)conf.getEnum("test.enum", (Enum)Yak.FOO);
        }
        catch (IllegalArgumentException e) {
            fail = true;
        }
        TestConfiguration.assertTrue((boolean)fail);
    }

    public void testTimeDuration() {
        Configuration conf = new Configuration(false);
        conf.setTimeDuration("test.time.a", 7L, TimeUnit.SECONDS);
        TestConfiguration.assertEquals((String)"7s", (String)conf.get("test.time.a"));
        TestConfiguration.assertEquals((long)0L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MINUTES));
        TestConfiguration.assertEquals((long)7L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.SECONDS));
        TestConfiguration.assertEquals((long)7000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MILLISECONDS));
        TestConfiguration.assertEquals((long)7000000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MICROSECONDS));
        TestConfiguration.assertEquals((long)7000000000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.NANOSECONDS));
        conf.setTimeDuration("test.time.b", 1L, TimeUnit.DAYS);
        TestConfiguration.assertEquals((String)"1d", (String)conf.get("test.time.b"));
        TestConfiguration.assertEquals((long)1L, (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.DAYS));
        TestConfiguration.assertEquals((long)24L, (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.HOURS));
        TestConfiguration.assertEquals((long)TimeUnit.MINUTES.convert(1L, TimeUnit.DAYS), (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.MINUTES));
        TestConfiguration.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.X", 30L, TimeUnit.SECONDS));
        conf.set("test.time.X", "30");
        TestConfiguration.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.X", 40L, TimeUnit.SECONDS));
        for (Configuration.ParsedTimeDuration ptd : Configuration.ParsedTimeDuration.values()) {
            conf.setTimeDuration("test.time.unit", 1L, ptd.unit());
            TestConfiguration.assertEquals((String)(1 + ptd.suffix()), (String)conf.get("test.time.unit"));
            TestConfiguration.assertEquals((long)1L, (long)conf.getTimeDuration("test.time.unit", 2L, ptd.unit()));
        }
    }

    public void testPattern() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.pattern1", "");
        this.appendProperty("test.pattern2", "(");
        this.appendProperty("test.pattern3", "a+b");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Pattern defaultPattern = Pattern.compile("x+");
        TestConfiguration.assertEquals((String)defaultPattern.pattern(), (String)this.conf.getPattern("xxxxx", defaultPattern).pattern());
        TestConfiguration.assertNull((Object)this.conf.getPattern("test.pattern1", null));
        TestConfiguration.assertEquals((String)defaultPattern.pattern(), (String)this.conf.getPattern("test.pattern1", defaultPattern).pattern());
        TestConfiguration.assertEquals((String)defaultPattern.pattern(), (String)this.conf.getPattern("test.pattern2", defaultPattern).pattern());
        TestConfiguration.assertEquals((String)"a+b", (String)this.conf.getPattern("test.pattern3", defaultPattern).pattern());
    }

    public void testPropertySource() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.foo", "bar");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.conf.set("fs.defaultFS", "value");
        String[] sources = this.conf.getPropertySources("test.foo");
        TestConfiguration.assertEquals((int)1, (int)sources.length);
        TestConfiguration.assertEquals((String)"Resource string returned for a file-loaded property must be a proper absolute path", (Object)fileResource, (Object)new Path(sources[0]));
        Assert.assertArrayEquals((String)"Resource string returned for a set() property must be \"programatically\"", (Object[])new String[]{"programatically"}, (Object[])this.conf.getPropertySources("fs.defaultFS"));
        TestConfiguration.assertEquals((String)"Resource string returned for an unset property must be null", null, (Object)this.conf.getPropertySources("fs.defaultFoo"));
    }

    public void testMultiplePropertySource() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.foo", "bar", false, "a", "b", "c");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        String[] sources = this.conf.getPropertySources("test.foo");
        TestConfiguration.assertEquals((int)4, (int)sources.length);
        TestConfiguration.assertEquals((String)"a", (String)sources[0]);
        TestConfiguration.assertEquals((String)"b", (String)sources[1]);
        TestConfiguration.assertEquals((String)"c", (String)sources[2]);
        TestConfiguration.assertEquals((String)"Resource string returned for a file-loaded property must be a proper absolute path", (Object)fileResource, (Object)new Path(sources[3]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSocketAddress() throws IOException {
        Configuration conf = new Configuration();
        String defaultAddr = "host:1";
        int defaultPort = 2;
        InetSocketAddress addr = null;
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        TestConfiguration.assertEquals((String)"host:1", (String)NetUtils.getHostPortString((InetSocketAddress)addr));
        conf.set("myAddress", "host2");
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        TestConfiguration.assertEquals((String)"host2:2", (String)NetUtils.getHostPortString((InetSocketAddress)addr));
        conf.set("myAddress", "host2:3");
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        TestConfiguration.assertEquals((String)"host2:3", (String)NetUtils.getHostPortString((InetSocketAddress)addr));
        boolean threwException = false;
        conf.set("myAddress", "bad:-port");
        try {
            addr = conf.getSocketAddr("myAddress", "host:1", 2);
        }
        catch (IllegalArgumentException iae) {
            threwException = true;
            TestConfiguration.assertEquals((String)"Does not contain a valid host:port authority: bad:-port (configuration property 'myAddress')", (String)iae.getMessage());
        }
        finally {
            TestConfiguration.assertTrue((boolean)threwException);
        }
    }

    public void testSetSocketAddress() throws IOException {
        Configuration conf = new Configuration();
        NetUtils.addStaticResolution((String)"host", (String)"127.0.0.1");
        String defaultAddr = "host:1";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)"host:1");
        conf.setSocketAddr("myAddress", addr);
        TestConfiguration.assertEquals((String)"host:1", (String)NetUtils.getHostPortString((InetSocketAddress)addr));
    }

    public void testUpdateSocketAddress() throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)"host", (int)1);
        InetSocketAddress connectAddr = this.conf.updateConnectAddr("myAddress", addr);
        TestConfiguration.assertEquals((String)connectAddr.getHostName(), (String)addr.getHostName());
        addr = new InetSocketAddress(1);
        connectAddr = this.conf.updateConnectAddr("myAddress", addr);
        TestConfiguration.assertEquals((String)connectAddr.getHostName(), (String)InetAddress.getLocalHost().getHostName());
    }

    public void testReload() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1", true, new String[0]);
        this.appendProperty("test.key2", "value2");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.conf.set("test.key3", "value4");
        this.conf.set("test.key4", "value5");
        TestConfiguration.assertEquals((String)"final-value1", (String)this.conf.get("test.key1"));
        TestConfiguration.assertEquals((String)"value2", (String)this.conf.get("test.key2"));
        TestConfiguration.assertEquals((String)"value4", (String)this.conf.get("test.key3"));
        TestConfiguration.assertEquals((String)"value5", (String)this.conf.get("test.key4"));
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1");
        this.appendProperty("test.key3", "final-value3", true, new String[0]);
        this.endConfig();
        this.conf.reloadConfiguration();
        TestConfiguration.assertEquals((String)"value1", (String)this.conf.get("test.key1"));
        TestConfiguration.assertEquals((String)"value4", (String)this.conf.get("test.key3"));
        TestConfiguration.assertEquals(null, (String)this.conf.get("test.key2"));
        TestConfiguration.assertEquals((String)"value5", (String)this.conf.get("test.key4"));
    }

    public void testSize() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        TestConfiguration.assertEquals((int)2, (int)conf.size());
    }

    public void testClear() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        conf.clear();
        TestConfiguration.assertEquals((int)0, (int)conf.size());
        TestConfiguration.assertFalse((boolean)conf.iterator().hasNext());
    }

    public void testClassLoader() {
        Configuration conf = new Configuration(false);
        conf.setQuietMode(false);
        conf.setClassLoader((ClassLoader)new Fake_ClassLoader());
        Configuration other = new Configuration(conf);
        TestConfiguration.assertTrue((boolean)(other.getClassLoader() instanceof Fake_ClassLoader));
    }

    public void testGetSetTrimmedNames() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set(" name", "value");
        TestConfiguration.assertEquals((String)"value", (String)conf.get("name"));
        TestConfiguration.assertEquals((String)"value", (String)conf.get(" name"));
        TestConfiguration.assertEquals((String)"value", (String)conf.getRaw("  name  "));
    }

    public void testDumpConfiguration() throws IOException {
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int defaultLength = jconf.getProperties().length;
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true, new String[0]);
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int length = jconf.getProperties().length;
        TestConfiguration.assertEquals((int)length, (int)(defaultLength + 3));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "newValue1");
        this.appendProperty("test.key2", "newValue2");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((String)"newValue1", (String)((JsonProperty)confDump.get("test.key1")).getValue());
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource1.toString(), (String)((JsonProperty)confDump.get("test.key1")).getResource());
        TestConfiguration.assertEquals((String)"value2", (String)((JsonProperty)confDump.get("test.key2")).getValue());
        TestConfiguration.assertEquals((boolean)true, (boolean)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource.toString(), (String)((JsonProperty)confDump.get("test.key2")).getResource());
        TestConfiguration.assertEquals((String)"value3", (String)((JsonProperty)confDump.get("test.key3")).getValue());
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key3")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource.toString(), (String)((JsonProperty)confDump.get("test.key3")).getResource());
        this.conf.set("test.key4", "value4");
        this.conf.set("test.key5", "value5");
        this.conf.set("test.key6", "${test.key5}");
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        confDump = new HashMap();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((String)"value5", (String)((JsonProperty)confDump.get("test.key6")).getValue());
        TestConfiguration.assertEquals((String)"programatically", (String)((JsonProperty)confDump.get("test.key4")).getResource());
        outWriter.close();
    }

    public void testDumpConfiguratioWithoutDefaults() throws IOException {
        Configuration config = new Configuration(false);
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        TestConfiguration.assertEquals((int)0, (int)jconf.getProperties().length);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true, new String[0]);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        config.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((int)2, (int)jconf.getProperties().length);
        TestConfiguration.assertEquals((String)((JsonProperty)confDump.get("test.key1")).getValue(), (String)"value1");
        TestConfiguration.assertEquals((String)((JsonProperty)confDump.get("test.key2")).getValue(), (String)"value2");
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        TestConfiguration.assertEquals((boolean)true, (boolean)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        for (JsonProperty prop : jconf.getProperties()) {
            TestConfiguration.assertEquals((String)fileResource.toString(), (String)prop.getResource());
        }
    }

    public void testGetValByRegex() {
        Configuration conf = new Configuration();
        String key1 = "t.abc.key1";
        String key2 = "t.abc.key2";
        String key3 = "tt.abc.key3";
        String key4 = "t.abc.ey3";
        conf.set(key1, "value1");
        conf.set(key2, "value2");
        conf.set(key3, "value3");
        conf.set(key4, "value3");
        Map res = conf.getValByRegex("^t\\..*\\.key\\d");
        TestConfiguration.assertTrue((String)("Conf didn't get key " + key1), (boolean)res.containsKey(key1));
        TestConfiguration.assertTrue((String)("Conf didn't get key " + key2), (boolean)res.containsKey(key2));
        TestConfiguration.assertTrue((String)("Picked out wrong key " + key3), (!res.containsKey(key3) ? 1 : 0) != 0);
        TestConfiguration.assertTrue((String)("Picked out wrong key " + key4), (!res.containsKey(key4) ? 1 : 0) != 0);
    }

    public void testSettingValueNull() throws Exception {
        Configuration config = new Configuration();
        try {
            config.set("testClassName", null);
            TestConfiguration.fail((String)"Should throw an IllegalArgumentException exception ");
        }
        catch (Exception e) {
            TestConfiguration.assertTrue((boolean)(e instanceof IllegalArgumentException));
            TestConfiguration.assertEquals((String)e.getMessage(), (String)"The value of property testClassName must not be null");
        }
    }

    public void testSettingKeyNull() throws Exception {
        Configuration config = new Configuration();
        try {
            config.set(null, "test");
            TestConfiguration.fail((String)"Should throw an IllegalArgumentException exception ");
        }
        catch (Exception e) {
            TestConfiguration.assertTrue((boolean)(e instanceof IllegalArgumentException));
            TestConfiguration.assertEquals((String)e.getMessage(), (String)"Property name must not be null");
        }
    }

    public void testGetClassByNameOrNull() throws Exception {
        Configuration config = new Configuration();
        Class clazz = config.getClassByNameOrNull("java.lang.Object");
        TestConfiguration.assertNotNull((Object)clazz);
    }

    public void testGetFinalParameters() throws Exception {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.var", "x", "x", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf = new Configuration();
        Set finalParameters = conf.getFinalParameters();
        TestConfiguration.assertFalse((String)"my.var already exists", (boolean)finalParameters.contains("my.var"));
        conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)"my.var is undefined", (String)"x", (String)conf.get("my.var"));
        TestConfiguration.assertFalse((String)"finalparams not copied", (boolean)finalParameters.contains("my.var"));
        finalParameters = conf.getFinalParameters();
        TestConfiguration.assertTrue((String)"my.var is not final", (boolean)finalParameters.contains("my.var"));
    }

    public static void main(String[] argv) throws Exception {
        TestRunner.main((String[])new String[]{TestConfiguration.class.getName()});
    }

    static class JsonProperty {
        String key;
        String value;
        boolean isFinal;
        String resource;

        JsonProperty() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean getIsFinal() {
            return this.isFinal;
        }

        public void setIsFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }
    }

    static class JsonConfiguration {
        JsonProperty[] properties;

        JsonConfiguration() {
        }

        public JsonProperty[] getProperties() {
            return this.properties;
        }

        public void setProperties(JsonProperty[] properties) {
            this.properties = properties;
        }
    }

    public static class Fake_ClassLoader
    extends ClassLoader {
    }

    static enum Yak {
        RAB,
        FOO;

    }

    static enum Dingo {
        FOO,
        BAR;

    }

    static class Prop {
        String name;
        String val;
        String expectEval;

        Prop() {
        }
    }
}

