/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestReconfiguration {
    private Configuration conf1;
    private Configuration conf2;
    private static final String PROP1 = "test.prop.one";
    private static final String PROP2 = "test.prop.two";
    private static final String PROP3 = "test.prop.three";
    private static final String PROP4 = "test.prop.four";
    private static final String PROP5 = "test.prop.five";
    private static final String VAL1 = "val1";
    private static final String VAL2 = "val2";

    @Before
    public void setUp() {
        this.conf1 = new Configuration();
        this.conf2 = new Configuration();
        this.conf1.set(PROP1, VAL1);
        this.conf1.set(PROP2, VAL1);
        this.conf1.set(PROP3, VAL1);
        this.conf2.set(PROP1, VAL1);
        this.conf2.set(PROP2, VAL2);
        this.conf2.set(PROP4, VAL1);
    }

    @Test
    public void testGetChangedProperties() {
        Collection changes = ReconfigurationUtil.getChangedProperties((Configuration)this.conf2, (Configuration)this.conf1);
        Assert.assertTrue((String)("expected 3 changed properties but got " + changes.size()), (changes.size() == 3 ? 1 : 0) != 0);
        boolean changeFound = false;
        boolean unsetFound = false;
        boolean setFound = false;
        for (ReconfigurationUtil.PropertyChange c : changes) {
            if (c.prop.equals(PROP2) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal != null && c.newVal.equals(VAL2)) {
                changeFound = true;
                continue;
            }
            if (c.prop.equals(PROP3) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal == null) {
                unsetFound = true;
                continue;
            }
            if (!c.prop.equals(PROP4) || c.oldVal != null || c.newVal == null || !c.newVal.equals(VAL1)) continue;
            setFound = true;
        }
        Assert.assertTrue((String)"not all changes have been applied", (changeFound && unsetFound && setFound ? 1 : 0) != 0);
    }

    @Test
    public void testReconfigure() {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertTrue((String)"test.prop.one set to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL1));
        Assert.assertTrue((String)"test.prop.two set to wrong value ", (boolean)dummy.getConf().get(PROP2).equals(VAL1));
        Assert.assertTrue((String)"test.prop.three set to wrong value ", (boolean)dummy.getConf().get(PROP3).equals(VAL1));
        Assert.assertTrue((String)"test.prop.four set to wrong value ", (dummy.getConf().get(PROP4) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"test.prop.five set to wrong value ", (dummy.getConf().get(PROP5) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"test.prop.one should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP1));
        Assert.assertTrue((String)"test.prop.two should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP2));
        Assert.assertFalse((String)"test.prop.three should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP3));
        Assert.assertTrue((String)"test.prop.four should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP4));
        Assert.assertFalse((String)"test.prop.five should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP5));
        boolean exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL1);
            Assert.assertTrue((String)"test.prop.one set to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL1));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, null);
            Assert.assertTrue((String)"test.prop.oneset to wrong value ", (dummy.getConf().get(PROP1) == null ? 1 : 0) != 0);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL2);
            Assert.assertTrue((String)"test.prop.oneset to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL2));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, null);
            Assert.assertTrue((String)"test.prop.fourset to wrong value ", (dummy.getConf().get(PROP4) == null ? 1 : 0) != 0);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, VAL1);
            Assert.assertTrue((String)"test.prop.fourset to wrong value ", (boolean)dummy.getConf().get(PROP4).equals(VAL1));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, VAL1);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, VAL2);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
    }

    @Test
    public void testThread() throws ReconfigurationException {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertTrue((boolean)dummy.getConf().get(PROP1).equals(VAL1));
        Thread dummyThread = new Thread(dummy);
        dummyThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        dummy.reconfigureProperty(PROP1, VAL2);
        long endWait = Time.now() + 2000L;
        while (dummyThread.isAlive() && Time.now() < endWait) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignore) {}
        }
        Assert.assertFalse((String)"dummy thread should not be alive", (boolean)dummyThread.isAlive());
        dummy.running = false;
        try {
            dummyThread.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        Assert.assertTrue((String)"test.prop.one is set to wrong value", (boolean)dummy.getConf().get(PROP1).equals(VAL2));
    }

    private static void waitAsyncReconfigureTaskFinish(ReconfigurableBase rb) throws InterruptedException {
        ReconfigurationTaskStatus status = null;
        for (int count = 20; count > 0 && !(status = rb.getReconfigurationTaskStatus()).stopped(); --count) {
            Thread.sleep(500L);
        }
        assert (status.stopped());
    }

    @Test
    public void testAsyncReconfigure() throws ReconfigurationException, IOException, InterruptedException {
        AsyncReconfigurableDummy dummy = (AsyncReconfigurableDummy)((Object)Mockito.spy((Object)((Object)new AsyncReconfigurableDummy(this.conf1))));
        ArrayList changes = Lists.newArrayList();
        changes.add(new ReconfigurationUtil.PropertyChange("name1", "new1", "old1"));
        changes.add(new ReconfigurationUtil.PropertyChange("name2", "new2", "old2"));
        changes.add(new ReconfigurationUtil.PropertyChange("name3", "new3", "old3"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)changes).when((Object)dummy))).getChangedProperties((Configuration)Matchers.any(Configuration.class), (Configuration)Matchers.any(Configuration.class));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)true).when((Object)dummy))).isPropertyReconfigurable((String)Matchers.eq((Object)"name1"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)false).when((Object)dummy))).isPropertyReconfigurable((String)Matchers.eq((Object)"name2"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)true).when((Object)dummy))).isPropertyReconfigurable((String)Matchers.eq((Object)"name3"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doNothing().when((Object)dummy))).reconfigurePropertyImpl((String)Matchers.eq((Object)"name1"), Matchers.anyString());
        ((AsyncReconfigurableDummy)((Object)Mockito.doNothing().when((Object)dummy))).reconfigurePropertyImpl((String)Matchers.eq((Object)"name2"), Matchers.anyString());
        ((AsyncReconfigurableDummy)((Object)Mockito.doThrow((Throwable)new ReconfigurationException("NAME3", "NEW3", "OLD3")).when((Object)dummy))).reconfigurePropertyImpl((String)Matchers.eq((Object)"name3"), Matchers.anyString());
        dummy.startReconfigurationTask();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        ReconfigurationTaskStatus status = dummy.getReconfigurationTaskStatus();
        Assert.assertEquals((long)3L, (long)status.getStatus().size());
        for (Map.Entry result : status.getStatus().entrySet()) {
            ReconfigurationUtil.PropertyChange change = (ReconfigurationUtil.PropertyChange)result.getKey();
            if (change.prop.equals("name1")) {
                Assert.assertFalse((boolean)((Optional)result.getValue()).isPresent());
                continue;
            }
            if (change.prop.equals("name2")) {
                MatcherAssert.assertThat((Object)((Optional)result.getValue()).get(), (Matcher)CoreMatchers.containsString((String)"Property name2 is not reconfigurable"));
                continue;
            }
            if (change.prop.equals("name3")) {
                MatcherAssert.assertThat((Object)((Optional)result.getValue()).get(), (Matcher)CoreMatchers.containsString((String)"NAME3"));
                continue;
            }
            Assert.fail((String)("Unknown property: " + change.prop));
        }
    }

    @Test(timeout=30000L)
    public void testStartReconfigurationFailureDueToExistingRunningTask() throws InterruptedException, IOException {
        AsyncReconfigurableDummy dummy = (AsyncReconfigurableDummy)((Object)Mockito.spy((Object)((Object)new AsyncReconfigurableDummy(this.conf1))));
        ArrayList changes = Lists.newArrayList((Object[])new ReconfigurationUtil.PropertyChange[]{new ReconfigurationUtil.PropertyChange(PROP1, "new1", "old1")});
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)changes).when((Object)dummy))).getChangedProperties((Configuration)Matchers.any(Configuration.class), (Configuration)Matchers.any(Configuration.class));
        ReconfigurationTaskStatus status = dummy.getReconfigurationTaskStatus();
        Assert.assertFalse((boolean)status.hasTask());
        dummy.startReconfigurationTask();
        status = dummy.getReconfigurationTaskStatus();
        Assert.assertTrue((boolean)status.hasTask());
        Assert.assertFalse((boolean)status.stopped());
        try {
            dummy.startReconfigurationTask();
            Assert.fail((String)"Expect to throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Another reconfiguration task is running", e);
        }
        status = dummy.getReconfigurationTaskStatus();
        Assert.assertTrue((boolean)status.hasTask());
        Assert.assertFalse((boolean)status.stopped());
        dummy.latch.countDown();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        status = dummy.getReconfigurationTaskStatus();
        Assert.assertTrue((boolean)status.hasTask());
        Assert.assertTrue((boolean)status.stopped());
        dummy.startReconfigurationTask();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        ReconfigurationTaskStatus status2 = dummy.getReconfigurationTaskStatus();
        Assert.assertTrue((status2.getStartTime() >= status.getEndTime() ? 1 : 0) != 0);
        dummy.shutdownReconfigurationTask();
        try {
            dummy.startReconfigurationTask();
            Assert.fail((String)"Expect to throw IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("The server is stopped", e);
        }
    }

    private static class AsyncReconfigurableDummy
    extends ReconfigurableBase {
        final CountDownLatch latch = new CountDownLatch(1);

        AsyncReconfigurableDummy(Configuration conf) {
            super(conf);
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReconfiguration.PROP1, TestReconfiguration.PROP2, TestReconfiguration.PROP4);
        }

        public synchronized void reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class ReconfigurableDummy
    extends ReconfigurableBase
    implements Runnable {
        public volatile boolean running = true;

        public ReconfigurableDummy(Configuration conf) {
            super(conf);
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReconfiguration.PROP1, TestReconfiguration.PROP2, TestReconfiguration.PROP4);
        }

        public synchronized void reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
        }

        @Override
        public void run() {
            while (this.running && this.getConf().get(TestReconfiguration.PROP1).equals(TestReconfiguration.VAL1)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

