/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.crypto.key.kms.ValueQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestValueQueue {
    @Test
    public void testInitFill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    public void testWarmUp() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        vq.initializeQueuesForKeys(new String[]{"k1", "k2", "k3"});
        FillInfo[] fillInfos = new FillInfo[]{filler.getTop(), filler.getTop(), filler.getTop()};
        Assert.assertEquals((long)5L, (long)fillInfos[0].num);
        Assert.assertEquals((long)5L, (long)fillInfos[1].num);
        Assert.assertEquals((long)5L, (long)fillInfos[2].num);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"k1", "k2", "k3"}), (Object)Sets.newHashSet((Object[])new String[]{fillInfos[0].key, fillInfos[1].key, fillInfos[2].key}));
        vq.shutdown();
    }

    @Test
    public void testRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.getNext("k1");
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    public void testNoRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)5L, (long)filler.getTop().num);
        Assert.assertEquals(null, (Object)filler.getTop());
        vq.shutdown();
    }

    @Test
    public void testgetAtMostPolicyALL() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((long)10L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        Assert.assertEquals((long)19L, (long)vq.getAtMost("k1", 19).size());
        Assert.assertEquals((long)19L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    public void testgetAtMostPolicyATLEAST_ONE() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 300L, 1, ValueQueue.SyncGenerationPolicy.ATLEAST_ONE, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)3L, (long)filler.getTop().num);
        Assert.assertEquals((long)2L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    public void testgetAtMostPolicyLOW_WATERMARK() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 300L, 1, ValueQueue.SyncGenerationPolicy.LOW_WATERMARK, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)3L, (long)filler.getTop().num);
        Assert.assertEquals((long)3L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    public void testDrain() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.drain("k1");
        Assert.assertNull((Object)filler.getTop());
        vq.shutdown();
    }

    private static class MockFiller
    implements ValueQueue.QueueRefiller<String> {
        final LinkedBlockingQueue<FillInfo> fillCalls = new LinkedBlockingQueue();

        private MockFiller() {
        }

        public void fillQueueForKey(String keyName, Queue<String> keyQueue, int numValues) throws IOException {
            this.fillCalls.add(new FillInfo(numValues, keyName));
            for (int i = 0; i < numValues; ++i) {
                keyQueue.add("test");
            }
        }

        public FillInfo getTop() throws InterruptedException {
            return this.fillCalls.poll(500L, TimeUnit.MILLISECONDS);
        }
    }

    private static class FillInfo {
        final int num;
        final String key;

        FillInfo(int num, String key) {
            this.num = num;
            this.key = key;
        }
    }
}

