/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.localfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.util.Shell;

public class LocalFSContract
extends AbstractFSContract {
    public static final String CONTRACT_XML = "contract/localfs.xml";
    public static final String SYSPROP_TEST_BUILD_DATA = "test.build.data";
    public static final String DEFAULT_TEST_BUILD_DATA_DIR = "test/build/data";
    private FileSystem fs;

    public LocalFSContract(Configuration conf) {
        super(conf);
        this.addConfResource(this.getContractXml());
    }

    protected String getContractXml() {
        return CONTRACT_XML;
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.fs = this.getLocalFS();
        this.adjustContractToLocalEnvironment();
    }

    protected void adjustContractToLocalEnvironment() {
        if (Shell.WINDOWS) {
            this.getConf().setBoolean(this.getConfKey("is-case-sensitive"), false);
            this.getConf().setBoolean(this.getConfKey("supports-unix-permissions"), false);
        } else if (ContractTestUtils.isOSX()) {
            this.getConf().setBoolean(this.getConfKey("is-case-sensitive"), false);
        }
    }

    protected FileSystem getLocalFS() throws IOException {
        return FileSystem.getLocal((Configuration)this.getConf());
    }

    @Override
    public FileSystem getTestFileSystem() throws IOException {
        return this.fs;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public Path getTestPath() {
        Path path = this.fs.makeQualified(new Path(this.getTestDataDir()));
        return path;
    }

    protected String getTestDataDir() {
        return System.getProperty(SYSPROP_TEST_BUILD_DATA, DEFAULT_TEST_BUILD_DATA_DIR);
    }
}

