/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;

public class TestSequenceFileSerialization
extends TestCase {
    private Configuration conf;
    private FileSystem fs;

    protected void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testJavaSerialization() throws Exception {
        Path file = new Path(System.getProperty("test.build.data", ".") + "/testseqser.seq");
        this.fs.delete(file, true);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)file, Long.class, String.class);
        writer.append((Object)1L, (Object)"one");
        writer.append((Object)2L, (Object)"two");
        writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, file, this.conf);
        TestSequenceFileSerialization.assertEquals((Object)1L, (Object)reader.next((Object)null));
        TestSequenceFileSerialization.assertEquals((Object)"one", (Object)reader.getCurrentValue((Object)null));
        TestSequenceFileSerialization.assertEquals((Object)2L, (Object)reader.next((Object)null));
        TestSequenceFileSerialization.assertEquals((Object)"two", (Object)reader.getCurrentValue((Object)null));
        TestSequenceFileSerialization.assertNull((Object)reader.next((Object)null));
        reader.close();
    }
}

