/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Stopwatch;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Test;

public class TestDataChecksum {
    private static final int SUMS_OFFSET_IN_BUFFER = 3;
    private static final int DATA_OFFSET_IN_BUFFER = 3;
    private static final int DATA_TRAILER_IN_BUFFER = 3;
    private static final int BYTES_PER_CHUNK = 512;
    private static final DataChecksum.Type[] CHECKSUM_TYPES = new DataChecksum.Type[]{DataChecksum.Type.CRC32, DataChecksum.Type.CRC32C};

    @Test
    public void testBulkOps() throws Exception {
        for (DataChecksum.Type type : CHECKSUM_TYPES) {
            System.err.println("---- beginning tests with checksum type " + type + "----");
            DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)512);
            for (boolean useDirect : new boolean[]{false, true}) {
                this.doBulkTest(checksum, 1023, useDirect);
                this.doBulkTest(checksum, 1024, useDirect);
                this.doBulkTest(checksum, 1025, useDirect);
            }
        }
    }

    private void doBulkTest(DataChecksum checksum, int dataLength, boolean useDirect) throws Exception {
        System.err.println("Testing bulk checksums of length " + dataLength + " with " + (useDirect ? "direct" : "array-backed") + " buffers");
        new Harness(checksum, dataLength, useDirect).testCorrectness();
    }

    @Test
    public void commonUsagePerfTest() throws Exception {
        int NUM_RUNS = 5;
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32C, (int)512);
        int dataLength = 0x20000000;
        Harness h = new Harness(checksum, 0x20000000, true);
        for (int i = 0; i < 5; ++i) {
            Stopwatch s = new Stopwatch().start();
            checksum.calculateChunkedSums(h.dataBuf, h.checksumBuf);
            s.stop();
            System.err.println("Calculate run #" + i + ": " + s.elapsedTime(TimeUnit.MICROSECONDS) + "us");
            s = new Stopwatch().start();
            checksum.verifyChunkedSums(h.dataBuf, h.checksumBuf, "fake file", 0L);
            s.stop();
            System.err.println("Verify run #" + i + ": " + s.elapsedTime(TimeUnit.MICROSECONDS) + "us");
        }
    }

    @Test
    public void testEquality() {
        Assert.assertEquals((Object)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512), (Object)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512));
        Assert.assertFalse((boolean)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512).equals((Object)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)1024)));
        Assert.assertFalse((boolean)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512).equals((Object)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32C, (int)512)));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"DataChecksum(type=CRC32, chunkSize=512)", (Object)DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512).toString());
    }

    private static void corruptBufferOffset(ByteBuffer buf, int offset) {
        buf.put(offset, (byte)(buf.get(offset) + 1));
    }

    private static void uncorruptBufferOffset(ByteBuffer buf, int offset) {
        buf.put(offset, (byte)(buf.get(offset) - 1));
    }

    private static ByteBuffer directify(ByteBuffer dataBuf) {
        ByteBuffer newBuf = ByteBuffer.allocateDirect(dataBuf.capacity());
        newBuf.position(dataBuf.position());
        newBuf.mark();
        newBuf.put(dataBuf);
        newBuf.reset();
        newBuf.limit(dataBuf.limit());
        return newBuf;
    }

    private static class Harness {
        final DataChecksum checksum;
        final int dataLength;
        final int sumsLength;
        final int numSums;
        ByteBuffer dataBuf;
        ByteBuffer checksumBuf;

        Harness(DataChecksum checksum, int dataLength, boolean useDirect) {
            this.checksum = checksum;
            this.dataLength = dataLength;
            this.numSums = (dataLength - 1) / checksum.getBytesPerChecksum() + 1;
            this.sumsLength = this.numSums * checksum.getChecksumSize();
            byte[] data = new byte[dataLength + 3 + 3];
            new Random().nextBytes(data);
            this.dataBuf = ByteBuffer.wrap(data, 3, dataLength);
            byte[] checksums = new byte[3 + this.sumsLength];
            this.checksumBuf = ByteBuffer.wrap(checksums, 3, this.sumsLength);
            if (useDirect) {
                this.dataBuf = TestDataChecksum.directify(this.dataBuf);
                this.checksumBuf = TestDataChecksum.directify(this.checksumBuf);
            }
        }

        void testCorrectness() throws ChecksumException {
            this.checksum.calculateChunkedSums(this.dataBuf, this.checksumBuf);
            this.checksum.verifyChunkedSums(this.dataBuf, this.checksumBuf, "fake file", 0L);
            TestDataChecksum.corruptBufferOffset(this.checksumBuf, 0);
            this.checksum.verifyChunkedSums(this.dataBuf, this.checksumBuf, "fake file", 0L);
            TestDataChecksum.corruptBufferOffset(this.dataBuf, 0);
            this.dataBuf.limit(this.dataBuf.limit() + 1);
            TestDataChecksum.corruptBufferOffset(this.dataBuf, this.dataLength + 3);
            this.dataBuf.limit(this.dataBuf.limit() - 1);
            this.checksum.verifyChunkedSums(this.dataBuf, this.checksumBuf, "fake file", 0L);
            TestDataChecksum.corruptBufferOffset(this.checksumBuf, 3);
            try {
                this.checksum.verifyChunkedSums(this.dataBuf, this.checksumBuf, "fake file", 0L);
                Assert.fail((String)"Did not throw on bad checksums");
            }
            catch (ChecksumException ce) {
                Assert.assertEquals((long)0L, (long)ce.getPos());
            }
            TestDataChecksum.uncorruptBufferOffset(this.checksumBuf, 3);
            TestDataChecksum.corruptBufferOffset(this.checksumBuf, 3 + this.sumsLength - 1);
            try {
                this.checksum.verifyChunkedSums(this.dataBuf, this.checksumBuf, "fake file", 0L);
                Assert.fail((String)"Did not throw on bad checksums");
            }
            catch (ChecksumException ce) {
                int expectedPos = this.checksum.getBytesPerChecksum() * (this.numSums - 1);
                Assert.assertEquals((long)expectedPos, (long)ce.getPos());
                Assert.assertTrue((boolean)ce.getMessage().contains("fake file"));
            }
        }
    }
}

