/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.crunch;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.Target;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroTableType;
import org.apache.crunch.types.avro.Avros;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.View;
import org.kitesdk.data.crunch.DatasetSourceTarget;
import org.kitesdk.data.crunch.DatasetTarget;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.StorageKey;

public class CrunchDatasets {
    public static <E> ReadableSource<E> asSource(View<E> view) {
        return new DatasetSourceTarget<E>(view);
    }

    public static <E> ReadableSource<E> asSource(URI uri, Class<E> type) {
        return new DatasetSourceTarget<E>(uri, type);
    }

    public static <E> ReadableSource<E> asSource(String uri, Class<E> type) {
        return CrunchDatasets.asSource(URI.create(uri), type);
    }

    public static <E> Target asTarget(View<E> view) {
        return new DatasetTarget<E>(view);
    }

    public static Target asTarget(String uri) {
        return CrunchDatasets.asTarget(URI.create(uri));
    }

    public static Target asTarget(URI uri) {
        return new DatasetTarget(uri);
    }

    public static <E> PCollection<E> partition(PCollection<E> collection, View<E> view) {
        return CrunchDatasets.partition(collection, view.getDataset(), -1);
    }

    public static <E> PCollection<E> partition(PCollection<E> collection, Dataset<E> dataset) {
        return CrunchDatasets.partition(collection, dataset, -1);
    }

    public static <E> PCollection<E> partition(PCollection<E> collection, View<E> view, int numWriters) {
        return CrunchDatasets.partition(collection, view, numWriters, 1);
    }

    public static <E> PCollection<E> partition(PCollection<E> collection, View<E> view, int numWriters, int numPartitionWriters) {
        DatasetDescriptor descriptor = view.getDataset().getDescriptor();
        if (descriptor.isPartitioned()) {
            GetStorageKey getKey = new GetStorageKey(view, numPartitionWriters);
            PTable table = collection.by(getKey, (PType)Avros.pairs((PType)Avros.generics((Schema)getKey.schema()), (PType)Avros.ints()));
            PGroupedTable grouped = numWriters > 0 ? table.groupByKey(numWriters) : table.groupByKey();
            return grouped.ungroup().values();
        }
        return CrunchDatasets.partition(collection, numWriters);
    }

    private static <E> PCollection<E> partition(PCollection<E> collection, int numReducers) {
        PType type = collection.getPType();
        AvroTableType tableType = Avros.tableOf((PType)type, (PType)Avros.nulls());
        PTable table = collection.parallelDo(new AsKeyTable(), (PTableType)tableType);
        PGroupedTable grouped = numReducers > 0 ? table.groupByKey(numReducers) : table.groupByKey();
        return grouped.ungroup().keys();
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="StorageKey equals is correct, compares the values")
    private static class AvroStorageKey
    extends GenericData.Record {
        private final StorageKey key;

        private AvroStorageKey(PartitionStrategy strategy, Schema schema) {
            super(SchemaUtil.keySchema((Schema)schema, (PartitionStrategy)strategy));
            this.key = new StorageKey(strategy);
        }

        public <E> AvroStorageKey reuseFor(E entity, @Nullable Map<String, Object> provided, EntityAccessor<E> accessor) {
            this.key.reuseFor(entity, provided, accessor);
            return this;
        }

        public void put(int i, Object v) {
            this.key.replace(i, v);
        }

        public Object get(int i) {
            return this.key.get(i);
        }
    }

    @SuppressWarnings(value={"SE_NO_SERIALVERSIONID", "SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Purposely not supported across versions, fields properly initialized")
    private static class GetStorageKey<E>
    extends MapFn<E, Pair<GenericData.Record, Integer>> {
        private final String strategyString;
        private final String schemaString;
        private final Class<E> type;
        private final Map<String, String> constraints;
        private final int numPartitionWriters;
        private transient AvroStorageKey key = null;
        private transient EntityAccessor<E> accessor = null;
        private transient Map<String, Object> provided = null;
        private transient int count;

        private GetStorageKey(View<E> view, int numPartitionWriters) {
            DatasetDescriptor descriptor = view.getDataset().getDescriptor();
            this.strategyString = descriptor.getPartitionStrategy().toString(false);
            this.schemaString = descriptor.getSchema().toString(false);
            this.type = view.getType();
            this.constraints = view instanceof AbstractRefinableView ? ((AbstractRefinableView)view).getConstraints().toQueryMap() : null;
            this.numPartitionWriters = numPartitionWriters > 0 ? numPartitionWriters : 1;
        }

        public Schema schema() {
            this.initialize();
            return this.key.getSchema();
        }

        public void initialize() {
            if (this.key == null) {
                PartitionStrategy strategy = PartitionStrategyParser.parse((String)this.strategyString);
                Schema schema = new Schema.Parser().parse(this.schemaString);
                this.key = new AvroStorageKey(strategy, schema);
                this.accessor = DataModelUtil.accessor(this.type, (Schema)schema);
                if (this.constraints != null) {
                    this.provided = Constraints.fromQueryMap((Schema)schema, (PartitionStrategy)strategy, this.constraints).getProvidedValues();
                }
            }
            this.count = 0;
        }

        public Pair<GenericData.Record, Integer> map(E entity) {
            int marker = this.count % this.numPartitionWriters;
            ++this.count;
            return Pair.of((Object)((Object)this.key.reuseFor(entity, this.provided, this.accessor)), (Object)marker);
        }
    }

    @SuppressWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Purposely not supported across versions")
    private static class AsKeyTable<E>
    extends DoFn<E, Pair<E, Void>> {
        private AsKeyTable() {
        }

        public void process(E entity, Emitter<Pair<E, Void>> emitter) {
            emitter.emit((Object)Pair.of(entity, (Object)null));
        }
    }
}

