/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.crunch;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.crunch.ReadableData;
import org.apache.crunch.Source;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.impl.mr.run.CrunchMapper;
import org.apache.crunch.io.CrunchInputs;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.crunch.DatasetTarget;
import org.kitesdk.data.crunch.KeyConverter;
import org.kitesdk.data.mapreduce.DatasetKeyInputFormat;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.SizeAccessor;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.shaded.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatasetSourceTarget<E>
extends DatasetTarget<E>
implements ReadableSourceTarget<E> {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetSourceTarget.class);
    private View<E> view;
    private FormatBundle formatBundle;
    private AvroType<E> avroType;

    public DatasetSourceTarget(View<E> view) {
        this(view, view.getType());
    }

    public DatasetSourceTarget(View<E> view, Class<E> type) {
        this(view, DatasetSourceTarget.toAvroType(view, type));
    }

    public DatasetSourceTarget(URI uri, Class<E> type) {
        this(Datasets.load((URI)uri, type));
    }

    public DatasetSourceTarget(View<E> view, AvroType<E> avroType) {
        super(view);
        this.view = view;
        this.avroType = avroType;
        Configuration temp = new Configuration(false);
        DatasetKeyInputFormat.configure((Configuration)temp).readFrom(view);
        this.formatBundle = DatasetSourceTarget.inputBundle(temp);
        Dataset dataset = view.getDataset();
        Format format = dataset.getDescriptor().getFormat();
        boolean isAvroOrParquetFile = dataset instanceof FileSystemDataset && (Formats.AVRO.equals((Object)format) || Formats.PARQUET.equals((Object)format));
        this.formatBundle.set("crunch.disable.combine.file", Boolean.toString(!isAvroOrParquetFile));
    }

    public DatasetSourceTarget(URI uri, AvroType<E> avroType) {
        this(Datasets.load((URI)uri, (Class)avroType.getTypeClass()), avroType);
    }

    private static <E> AvroType<E> toAvroType(View<E> view, Class<E> type) {
        if (type.isAssignableFrom(GenericData.Record.class)) {
            return Avros.generics((Schema)view.getDataset().getDescriptor().getSchema());
        }
        return Avros.records(type);
    }

    public Source<E> inputConf(String key, String value) {
        this.formatBundle.set(key, value);
        return this;
    }

    public PType<E> getType() {
        return this.avroType;
    }

    public Converter<?, ?, ?, ?> getConverter() {
        return new KeyConverter<E>(this.avroType);
    }

    public void configureSource(Job job, int inputId) throws IOException {
        Configuration conf = job.getConfiguration();
        if (inputId == -1) {
            job.setMapperClass(CrunchMapper.class);
            job.setInputFormatClass(this.formatBundle.getFormatClass());
            this.formatBundle.configure(conf);
        } else {
            Path dummy = new Path("/view/" + this.view.getDataset().getName());
            CrunchInputs.addInputPath((Job)job, (Path)dummy, (FormatBundle)this.formatBundle, (int)inputId);
        }
    }

    public long getSize(Configuration configuration) {
        if (this.view instanceof SizeAccessor) {
            return ((SizeAccessor)this.view).getSize();
        }
        LOG.warn("Cannot determine size for view: " + this.toString());
        return 1000000000L;
    }

    public long getLastModifiedAt(Configuration configuration) {
        if (this.view instanceof LastModifiedAccessor) {
            return ((LastModifiedAccessor)this.view).getLastModified();
        }
        LOG.warn("Cannot determine last modified time for source: " + this.toString());
        return -1L;
    }

    public Iterable<E> read(Configuration configuration) throws IOException {
        return this.view.newReader();
    }

    public ReadableData<E> asReadable() {
        return new ReadableData<E>(){

            public Set<SourceTarget<?>> getSourceTargets() {
                return ImmutableSet.of(DatasetSourceTarget.this);
            }

            public void configure(Configuration conf) {
            }

            public Iterable<E> read(TaskInputOutputContext<?, ?, ?, ?> context) throws IOException {
                return DatasetSourceTarget.this.view.newReader();
            }
        };
    }

    public SourceTarget<E> conf(String key, String value) {
        this.inputConf(key, value);
        this.outputConf(key, value);
        return this;
    }

    private static FormatBundle<DatasetKeyInputFormat> inputBundle(Configuration conf) {
        FormatBundle bundle = FormatBundle.forInput(DatasetKeyInputFormat.class);
        for (Map.Entry entry : conf) {
            bundle.set((String)entry.getKey(), (String)entry.getValue());
        }
        return bundle;
    }
}

