/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.crunch;

import java.net.URI;
import java.util.Map;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.io.CrunchOutputs;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.MapReduceTarget;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.View;
import org.kitesdk.data.crunch.DatasetSourceTarget;
import org.kitesdk.data.crunch.KeyConverter;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatasetTarget<E>
implements MapReduceTarget {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetTarget.class);
    private View view;
    private final URI uri;
    private final FormatBundle formatBundle;

    public DatasetTarget(View<E> view) {
        this.view = view;
        Configuration temp = DatasetTarget.emptyConf();
        DatasetKeyOutputFormat.configure((Configuration)temp).appendTo(view);
        this.formatBundle = DatasetTarget.outputBundle(temp);
        this.uri = view.getDataset().getUri();
    }

    public DatasetTarget(URI uri) {
        this.uri = uri;
        Configuration temp = DatasetTarget.emptyConf();
        DatasetKeyOutputFormat.configure((Configuration)temp).appendTo(uri);
        this.formatBundle = DatasetTarget.outputBundle(temp);
    }

    public Target outputConf(String key, String value) {
        this.formatBundle.set(key, value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleExisting(Target.WriteMode writeMode, long lastModForSource, Configuration entries) {
        boolean exists;
        this.outputConf("kite.outputMode", this.kiteWriteMode(writeMode).toString());
        if (this.view == null) {
            try {
                this.view = Datasets.load((URI)this.uri);
            }
            catch (DatasetNotFoundException e) {
                LOG.info("Writing to new dataset/view: " + this.uri);
                return true;
            }
        }
        boolean ready = false;
        if (this.view instanceof Signalable) {
            ready = ((Signalable)this.view).isReady();
        }
        boolean bl = exists = ready || !this.view.isEmpty();
        if (exists) {
            switch (writeMode) {
                case DEFAULT: {
                    LOG.error("Dataset/view " + this.view + " already exists!");
                    throw new CrunchRuntimeException("Dataset/view already exists: " + this.view);
                }
                case OVERWRITE: {
                    LOG.info("Overwriting existing dataset/view: " + this.view);
                    return exists;
                }
                case APPEND: {
                    LOG.info("Appending to existing dataset/view: " + this.view);
                    return exists;
                }
                case CHECKPOINT: {
                    long lastModForTarget = -1L;
                    if (this.view instanceof LastModifiedAccessor) {
                        lastModForTarget = ((LastModifiedAccessor)this.view).getLastModified();
                    }
                    if (ready && lastModForTarget > lastModForSource) {
                        LOG.info("Re-starting pipeline from checkpoint dataset/view: " + this.view);
                        return exists;
                    }
                    if (!ready) {
                        LOG.info("Checkpoint is not ready. Deleting data from existing checkpoint dataset/view: " + this.view);
                    } else {
                        LOG.info("Source data has recent updates. Deleting data from existing checkpoint dataset/view: " + this.view);
                    }
                    this.delete(this.view);
                    return false;
                }
                default: {
                    throw new CrunchRuntimeException("Unknown WriteMode:  " + writeMode);
                }
            }
        }
        LOG.info("Writing to empty dataset/view: " + this.view);
        return exists;
    }

    private DatasetKeyOutputFormat.WriteMode kiteWriteMode(Target.WriteMode mode) {
        switch (mode) {
            case DEFAULT: {
                return DatasetKeyOutputFormat.WriteMode.DEFAULT;
            }
            case APPEND: {
                return DatasetKeyOutputFormat.WriteMode.APPEND;
            }
            case OVERWRITE: {
                return DatasetKeyOutputFormat.WriteMode.OVERWRITE;
            }
        }
        return DatasetKeyOutputFormat.WriteMode.APPEND;
    }

    private void delete(View view) {
        try {
            boolean deleted = view.deleteAll();
            if (!deleted) {
                LOG.warn("No data was deleted.");
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.error("Dataset view " + view + " cannot be deleted!");
            throw new CrunchRuntimeException("Dataset view cannot be deleted:" + view, (Exception)e);
        }
    }

    public boolean accept(OutputHandler handler, PType<?> ptype) {
        if (!(ptype instanceof AvroType)) {
            return false;
        }
        handler.configure((Target)this, ptype);
        return true;
    }

    public Converter<?, ?, ?, ?> getConverter(PType<?> ptype) {
        if (ptype instanceof AvroType) {
            return new KeyConverter((AvroType)ptype);
        }
        throw new DatasetException("Cannot create converter for non-Avro type: " + ptype);
    }

    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (ptype instanceof AvroType) {
            if (this.view != null) {
                return new DatasetSourceTarget(this.view, (AvroType)ptype);
            }
            if (this.uri != null) {
                return new DatasetSourceTarget(this.uri, (AvroType)ptype);
            }
        }
        return null;
    }

    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        Preconditions.checkNotNull(name, "Output name should not be null");
        Converter<?, ?, ?, ?> converter = this.getConverter(ptype);
        Class keyClass = converter.getKeyClass();
        Class<Void> valueClass = Void.class;
        CrunchOutputs.addNamedOutput((Job)job, (String)name, (FormatBundle)this.formatBundle, (Class)keyClass, valueClass);
        job.setOutputFormatClass(this.formatBundle.getFormatClass());
        this.formatBundle.configure(job.getConfiguration());
    }

    private static Configuration emptyConf() {
        return new Configuration(false);
    }

    private static FormatBundle<DatasetKeyOutputFormat> outputBundle(Configuration conf) {
        FormatBundle bundle = FormatBundle.forOutput(DatasetKeyOutputFormat.class);
        for (Map.Entry entry : conf) {
            bundle.set((String)entry.getKey(), (String)entry.getValue());
        }
        return bundle;
    }

    public String toString() {
        return "Kite(" + this.uri + ")";
    }
}

