/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHBaseConfiguration {
    private static final Log LOG = LogFactory.getLog(TestHBaseConfiguration.class);

    @Test
    public void testGetIntDeprecated() {
        int VAL = 1;
        int VAL2 = 2;
        String NAME = "foo";
        String DEPRECATED_NAME = "foo.deprecated";
        Configuration conf = HBaseConfiguration.create();
        conf.setInt(NAME, VAL);
        Assert.assertEquals((long)VAL, (long)HBaseConfiguration.getInt((Configuration)conf, (String)NAME, (String)DEPRECATED_NAME, (int)0));
        conf = HBaseConfiguration.create();
        conf.setInt(DEPRECATED_NAME, VAL);
        Assert.assertEquals((long)VAL, (long)HBaseConfiguration.getInt((Configuration)conf, (String)NAME, (String)DEPRECATED_NAME, (int)0));
        conf = HBaseConfiguration.create();
        conf.setInt(DEPRECATED_NAME, VAL);
        conf.setInt(NAME, VAL);
        Assert.assertEquals((long)VAL, (long)HBaseConfiguration.getInt((Configuration)conf, (String)NAME, (String)DEPRECATED_NAME, (int)0));
        conf = HBaseConfiguration.create();
        conf.setInt(DEPRECATED_NAME, VAL);
        conf.setInt(NAME, VAL2);
        Assert.assertEquals((long)VAL, (long)HBaseConfiguration.getInt((Configuration)conf, (String)NAME, (String)DEPRECATED_NAME, (int)0));
    }

    @Test
    public void testGetPassword() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.credential.provider.path", "jceks://file/tmp/foo.jks");
        ReflectiveCredentialProviderClient client = new ReflectiveCredentialProviderClient();
        if (client.isHadoopCredentialProviderAvailable()) {
            char[] keyPass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
            char[] storePass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
            client.createEntry(conf, "ssl.keypass.alias", keyPass);
            client.createEntry(conf, "ssl.storepass.alias", storePass);
            String keypass = HBaseConfiguration.getPassword((Configuration)conf, (String)"ssl.keypass.alias", null);
            Assert.assertEquals((Object)keypass, (Object)new String(keyPass));
            String storepass = HBaseConfiguration.getPassword((Configuration)conf, (String)"ssl.storepass.alias", null);
            Assert.assertEquals((Object)storepass, (Object)new String(storePass));
        }
    }

    private static class ReflectiveCredentialProviderClient {
        public static final String HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME = "org.apache.hadoop.security.alias.JavaKeyStoreProvider$Factory";
        public static final String HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME = "getProviders";
        public static final String HADOOP_CRED_PROVIDER_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider";
        public static final String HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME = "getCredentialEntry";
        public static final String HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME = "getAliases";
        public static final String HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME = "createCredentialEntry";
        public static final String HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME = "flush";
        public static final String HADOOP_CRED_ENTRY_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider$CredentialEntry";
        public static final String HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME = "getCredential";
        public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
        private static Object hadoopCredProviderFactory = null;
        private static Method getProvidersMethod = null;
        private static Method getAliasesMethod = null;
        private static Method getCredentialEntryMethod = null;
        private static Method getCredentialMethod = null;
        private static Method createCredentialEntryMethod = null;
        private static Method flushMethod = null;
        private static Boolean hadoopClassesAvailable = null;

        private ReflectiveCredentialProviderClient() {
        }

        private boolean isHadoopCredentialProviderAvailable() {
            if (null != hadoopClassesAvailable) {
                return hadoopClassesAvailable != false && null != getProvidersMethod && null != hadoopCredProviderFactory && null != getCredentialEntryMethod && null != getCredentialMethod;
            }
            hadoopClassesAvailable = false;
            Class<?> hadoopCredProviderFactoryClz = null;
            try {
                hadoopCredProviderFactoryClz = Class.forName(HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            try {
                hadoopCredProviderFactory = hadoopCredProviderFactoryClz.newInstance();
            }
            catch (InstantiationException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
            try {
                getProvidersMethod = this.loadMethod(hadoopCredProviderFactoryClz, HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, Configuration.class);
                Class<?> hadoopCredProviderClz = null;
                hadoopCredProviderClz = Class.forName(HADOOP_CRED_PROVIDER_CLASS_NAME);
                getCredentialEntryMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME, String.class);
                getAliasesMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, new Class[0]);
                createCredentialEntryMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME, String.class, char[].class);
                flushMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME, new Class[0]);
                Class<?> hadoopCredentialEntryClz = null;
                try {
                    hadoopCredentialEntryClz = Class.forName(HADOOP_CRED_ENTRY_CLASS_NAME);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Failed to load class:" + e));
                    return false;
                }
                getCredentialMethod = this.loadMethod(hadoopCredentialEntryClz, HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME, new Class[0]);
            }
            catch (Exception e1) {
                return false;
            }
            hadoopClassesAvailable = true;
            LOG.info((Object)"Credential provider classes have been loaded and initialized successfully through reflection.");
            return true;
        }

        private Method loadMethod(Class<?> clz, String name, Class<?> ... classes) throws Exception {
            Method method = null;
            try {
                method = clz.getMethod(name, classes);
            }
            catch (SecurityException e) {
                Assert.fail((String)("security exception caught for: " + name + " in " + clz.getCanonicalName()));
                throw e;
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)("Failed to load the " + name + ": " + e));
                Assert.fail((String)("no such method: " + name + " in " + clz.getCanonicalName()));
                throw e;
            }
            return method;
        }

        protected List<Object> getCredentialProviders(Configuration conf) {
            Object providersObj = null;
            try {
                providersObj = getProvidersMethod.invoke(hadoopCredProviderFactory, conf);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Failed to invoke: " + getProvidersMethod.getName() + ": " + e));
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Failed to invoke: " + getProvidersMethod.getName() + ": " + e));
                return null;
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)("Failed to invoke: " + getProvidersMethod.getName() + ": " + e));
                return null;
            }
            try {
                return (List)providersObj;
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public void createEntry(Configuration conf, String name, char[] credential) throws Exception {
            if (!this.isHadoopCredentialProviderAvailable()) {
                return;
            }
            List<Object> providers = this.getCredentialProviders(conf);
            if (null == providers) {
                throw new IOException("Could not fetch any CredentialProviders, is the implementation available?");
            }
            Object provider = providers.get(0);
            this.createEntryInProvider(provider, name, credential);
        }

        private void createEntryInProvider(Object credentialProvider, String name, char[] credential) throws Exception {
            if (!this.isHadoopCredentialProviderAvailable()) {
                return;
            }
            try {
                createCredentialEntryMethod.invoke(credentialProvider, name, credential);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            catch (IllegalAccessException e) {
                return;
            }
            catch (InvocationTargetException e) {
                return;
            }
            try {
                flushMethod.invoke(credentialProvider, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
        }
    }
}

