/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressReportingInputStream;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.TreeHashGenerator;
import com.amazonaws.services.glacier.internal.TreeHashInputStream;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.transfer.JobStatusMonitor;
import com.amazonaws.services.glacier.transfer.UploadResult;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.util.BinaryUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveTransferManager {
    private static final long MAXIMUM_UPLOAD_PART_SIZE = 0x100000000L;
    private static final long DEFAULT_DOWNLOAD_CHUNK_SIZE = 0x8000000L;
    private static final long MINIMUM_PART_SIZE = 0x100000L;
    private static final long MULTIPART_UPLOAD_SIZE_THRESHOLD = 0x6400000L;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private final AmazonGlacier glacier;
    private final AWSCredentialsProvider credentialsProvider;
    private final ClientConfiguration clientConfiguration;
    private final AmazonSQSClient sqs;
    private final AmazonSNSClient sns;
    private static final Log log = LogFactory.getLog(ArchiveTransferManager.class);

    public ArchiveTransferManager(AWSCredentials credentials) {
        this(new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(new AmazonGlacierClient(credentialsProvider, clientConfiguration), credentialsProvider, clientConfiguration);
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider) {
        this(glacier, credentialsProvider, new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentials credentials) {
        this(glacier, new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.credentialsProvider = credentialsProvider;
        this.clientConfiguration = clientConfiguration;
        this.glacier = glacier;
        this.sns = null;
        this.sqs = null;
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AmazonSQSClient sqs, AmazonSNSClient sns) {
        this.credentialsProvider = null;
        this.clientConfiguration = null;
        this.glacier = glacier;
        this.sqs = sqs;
        this.sns = sns;
    }

    public UploadResult upload(String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        return this.upload(null, vaultName, archiveDescription, file);
    }

    public UploadResult upload(String accountId, String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        return this.upload(accountId, vaultName, archiveDescription, file, null);
    }

    public UploadResult upload(String accountId, String vaultName, String archiveDescription, File file, ProgressListener progressListener) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListener);
        if (file.length() > 0x6400000L) {
            return this.uploadInMultipleParts(accountId, vaultName, archiveDescription, file, progressListenerCallbackExecutor);
        }
        return this.uploadInSinglePart(accountId, vaultName, archiveDescription, file, progressListenerCallbackExecutor);
    }

    public void download(String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        this.download(null, vaultName, archiveId, file);
    }

    public void download(String accountId, String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        this.download(accountId, vaultName, archiveId, file, null);
    }

    public void download(String accountId, String vaultName, String archiveId, File file, ProgressListener progressListener) throws AmazonServiceException, AmazonClientException {
        JobStatusMonitor jobStatusMonitor = null;
        String jobId = null;
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListener);
        this.fireProgressEvent(progressListenerCallbackExecutor, 1);
        try {
            jobStatusMonitor = this.credentialsProvider != null && this.clientConfiguration != null ? new JobStatusMonitor(this.credentialsProvider, this.clientConfiguration) : new JobStatusMonitor(this.sqs, this.sns);
            JobParameters jobParameters = new JobParameters().withArchiveId(archiveId).withType("archive-retrieval").withSNSTopic(jobStatusMonitor.getTopicArn());
            InitiateJobResult archiveRetrievalResult = this.glacier.initiateJob(new InitiateJobRequest().withAccountId(accountId).withVaultName(vaultName).withJobParameters(jobParameters));
            jobId = archiveRetrievalResult.getJobId();
            jobStatusMonitor.waitForJobToComplete(jobId);
        }
        catch (AmazonServiceException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ace;
        }
        finally {
            if (jobStatusMonitor != null) {
                jobStatusMonitor.shutdown();
            }
        }
        this.downloadJobOutput(accountId, vaultName, jobId, file, progressListenerCallbackExecutor);
    }

    public void downloadJobOutput(String accountId, String vaultName, String jobId, File file) {
        this.downloadJobOutput(accountId, vaultName, jobId, file, (ProgressListenerCallbackExecutor)null);
    }

    public void downloadJobOutput(String accountId, String vaultName, String jobId, File file, ProgressListener progressListener) {
        this.downloadJobOutput(accountId, vaultName, jobId, file, ProgressListenerCallbackExecutor.wrapListener(progressListener));
    }

    private void downloadJobOutput(String accountId, String vaultName, String jobId, File file, ProgressListenerCallbackExecutor progressListenerCallbackExecutor) {
        long archiveSize = 0L;
        long chunkSize = 0x8000000L;
        long currentPosition = 0L;
        long endPosition = 0L;
        RandomAccessFile output = null;
        String customizedChunkSize = null;
        customizedChunkSize = System.getProperty("com.amazonaws.services.glacier.transfer.downloadChunkSizeInMB");
        DescribeJobResult describeJobResult = this.glacier.describeJob(new DescribeJobRequest(accountId, vaultName, jobId));
        archiveSize = describeJobResult.getArchiveSizeInBytes();
        if (customizedChunkSize != null) {
            try {
                chunkSize = Long.parseLong(customizedChunkSize) * 1024L * 1024L;
            }
            catch (NumberFormatException e) {
                this.fireProgressEvent(progressListenerCallbackExecutor, 8);
                throw new AmazonClientException("Invalid chunk size: " + e.getMessage());
            }
            this.validateChunkSize(chunkSize);
        }
        try {
            output = new RandomAccessFile(file, "rw");
        }
        catch (IOException e) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw new AmazonClientException("Unable to open the output file " + file.getPath(), e);
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        while (currentPosition < archiveSize) {
            endPosition = currentPosition + chunkSize > archiveSize ? archiveSize - 1L : currentPosition + chunkSize - 1L;
            try {
                this.downloadOneChunk(accountId, vaultName, jobId, output, currentPosition, endPosition);
            }
            catch (AmazonServiceException ace) {
                this.fireProgressEvent(progressListenerCallbackExecutor, 8);
                throw ace;
            }
            if (progressListenerCallbackExecutor != null) {
                ProgressEvent event = new ProgressEvent(endPosition - currentPosition + 1L);
                progressListenerCallbackExecutor.progressChanged(event);
            }
            currentPosition += chunkSize;
        }
        try {
            output.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 4);
    }

    private void validateChunkSize(long chunkSize) {
        if (chunkSize <= 0L) {
            throw new AmazonClientException("Invalid chunk size, chunk size must be great than 0");
        }
        if ((chunkSize & chunkSize - 1L) != 0L) {
            throw new AmazonClientException("Invalid chunk size, chunk size must be aligned on 2^n MB boundaries");
        }
    }

    private void downloadOneChunk(String accountId, String vaultName, String jobId, RandomAccessFile output, long currentPosition, long endPosition) {
        int retries = 0;
        while (true) {
            try {
                TreeHashInputStream input;
                GetJobOutputResult jobOutputResult = this.glacier.getJobOutput(new GetJobOutputRequest().withAccountId(accountId).withVaultName(vaultName).withRange("bytes=" + Long.toString(currentPosition) + "-" + Long.toString(endPosition)).withJobId(jobId));
                try {
                    input = new TreeHashInputStream(new BufferedInputStream(jobOutputResult.getBody()));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AmazonClientException("Unable to compute hash for data integrity: " + e.getMessage(), e);
                }
                this.appendToFile(output, input);
                if (null != jobOutputResult.getChecksum()) {
                    if (!input.getTreeHash().equalsIgnoreCase(jobOutputResult.getChecksum())) {
                        throw new IOException("Client side computed hash doesn't match server side hash; possible data corruption");
                    }
                } else {
                    log.warn((Object)"Cannot validate the downloaded output since no tree-hash checksum is returned from Glacier. Make sure the InitiateJob and GetJobOutput requests use tree-hash-aligned ranges.");
                }
                return;
            }
            catch (IOException ioe) {
                if (retries < 3) {
                    ++retries;
                    try {
                        output.seek(currentPosition);
                    }
                    catch (Exception e) {
                        throw new AmazonClientException("Unable to download the archive: " + ioe.getMessage(), e);
                    }
                    continue;
                }
                throw new AmazonClientException("Unable to download the archive: " + ioe.getMessage(), ioe);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(RandomAccessFile output, InputStream input) throws IOException {
        byte[] buffer = new byte[0x100000];
        try {
            int bytesRead = 0;
            do {
                if ((bytesRead = input.read(buffer)) < 0) {
                    break;
                }
                output.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    private long calculatePartSize(long fileSize) {
        long partSize = 0x100000L;
        int approxNumParts = 1;
        while (partSize * (long)approxNumParts < fileSize && partSize * 2L <= 0x100000000L) {
            partSize *= 2L;
            approxNumParts *= 2;
        }
        return partSize;
    }

    private InputSubstream newInputSubstream(File file, long startingPosition, long length) {
        try {
            return new InputSubstream(new RepeatableFileInputStream(file), startingPosition, length, true);
        }
        catch (FileNotFoundException e) {
            throw new AmazonClientException("Unable to find file '" + file.getAbsolutePath() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult uploadInMultipleParts(String accountId, String vaultName, String archiveDescription, File file, ProgressListenerCallbackExecutor progressListenerCallbackExecutor) {
        long partSize = this.calculatePartSize(file.length());
        String partSizeString = Long.toString(partSize);
        this.fireProgressEvent(progressListenerCallbackExecutor, 1);
        String uploadId = null;
        try {
            InitiateMultipartUploadResult initiateResult = this.glacier.initiateMultipartUpload(new InitiateMultipartUploadRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withPartSize(partSizeString));
            uploadId = initiateResult.getUploadId();
        }
        catch (AmazonServiceException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ace;
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        try {
            LinkedList<byte[]> binaryChecksums = new LinkedList<byte[]>();
            for (long currentPosition = 0L; currentPosition < file.length(); currentPosition += partSize) {
                long length = partSize;
                if (currentPosition + partSize > file.length()) {
                    length = file.length() - currentPosition;
                }
                Exception failedException = null;
                boolean completed = false;
                int tries = 0;
                while (!completed && tries < 5) {
                    ++tries;
                    InputSubstream inputSubStream = this.newInputSubstream(file, currentPosition, length);
                    ((InputStream)inputSubStream).mark(-1);
                    String checksum = TreeHashGenerator.calculateTreeHash(inputSubStream);
                    byte[] binaryChecksum = BinaryUtils.fromHex(checksum);
                    ((InputStream)inputSubStream).reset();
                    try {
                        this.glacier.uploadMultipartPart(new UploadMultipartPartRequest().withAccountId(accountId).withChecksum(checksum).withBody(inputSubStream).withRange("bytes " + currentPosition + "-" + (currentPosition + length - 1L) + "/*").withUploadId(uploadId).withVaultName(vaultName));
                        completed = true;
                        binaryChecksums.add(binaryChecksum);
                    }
                    catch (Exception e) {
                        failedException = e;
                    }
                    finally {
                        try {
                            ((InputStream)inputSubStream).close();
                        }
                        catch (Exception e) {}
                    }
                }
                if (!completed && failedException != null) {
                    throw failedException;
                }
                if (progressListenerCallbackExecutor == null) continue;
                ProgressEvent event = new ProgressEvent(length);
                progressListenerCallbackExecutor.progressChanged(event);
            }
            String checksum = TreeHashGenerator.calculateTreeHash(binaryChecksums);
            String archiveSize = Long.toString(file.length());
            CompleteMultipartUploadResult completeMultipartUploadResult = this.glacier.completeMultipartUpload(new CompleteMultipartUploadRequest().withAccountId(accountId).withArchiveSize(archiveSize).withVaultName(vaultName).withChecksum(checksum).withUploadId(uploadId));
            String artifactId = completeMultipartUploadResult.getArchiveId();
            this.fireProgressEvent(progressListenerCallbackExecutor, 4);
            return new UploadResult(artifactId);
        }
        catch (Exception e) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            this.glacier.abortMultipartUpload(new AbortMultipartUploadRequest(accountId, vaultName, uploadId));
            throw new AmazonClientException("Unable to finish the upload", e);
        }
    }

    private UploadResult uploadInSinglePart(String accountId, String vaultName, String archiveDescription, File file, ProgressListenerCallbackExecutor progressListenerCallbackExecutor) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        String checksum = TreeHashGenerator.calculateTreeHash(file);
        InputStream input = new RepeatableFileInputStream(file);
        if (progressListenerCallbackExecutor != null) {
            input = new ProgressReportingInputStream(input, progressListenerCallbackExecutor);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        }
        try {
            UploadArchiveResult uploadArchiveResult = this.glacier.uploadArchive(new UploadArchiveRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withChecksum(checksum).withBody(input).withContentLength(file.length()));
            String artifactId = uploadArchiveResult.getArchiveId();
            this.fireProgressEvent(progressListenerCallbackExecutor, 4);
            UploadResult uploadResult = new UploadResult(artifactId);
            return uploadResult;
        }
        catch (AmazonClientException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ace;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    private void fireProgressEvent(ProgressListenerCallbackExecutor listenerCallbackExecutor, int eventType) {
        if (listenerCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        listenerCallbackExecutor.progressChanged(event);
    }
}

