/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroRecordBuilder;
import org.kitesdk.data.hbase.avro.AvroRecordBuilderFactory;
import org.kitesdk.data.hbase.avro.GenericAvroRecordBuilderFactory;
import org.kitesdk.data.hbase.avro.SpecificAvroRecordBuilderFactory;
import org.kitesdk.data.hbase.impl.EntityComposer;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.PartitionKey;

public class AvroEntityComposer<E extends IndexedRecord>
implements EntityComposer<E> {
    private final AvroEntitySchema avroSchema;
    private final EntityAccessor<IndexedRecord> accessor;
    private final boolean specific;
    private final AvroRecordBuilderFactory<E> recordBuilderFactory;
    private final Map<String, AvroRecordBuilderFactory<E>> kacRecordBuilderFactories;

    public AvroEntityComposer(AvroEntitySchema avroEntitySchema, boolean specific) {
        this.avroSchema = avroEntitySchema;
        this.accessor = DataModelUtil.accessor(IndexedRecord.class, (Schema)this.avroSchema.getAvroSchema());
        this.specific = specific;
        this.recordBuilderFactory = this.buildAvroRecordBuilderFactory(avroEntitySchema.getAvroSchema());
        this.kacRecordBuilderFactories = new HashMap<String, AvroRecordBuilderFactory<E>>();
        this.initRecordBuilderFactories();
    }

    @Override
    public EntityComposer.Builder<E> getBuilder() {
        return new EntityComposer.Builder<E>(){
            private final AvroRecordBuilder<E> recordBuilder;
            {
                this.recordBuilder = AvroEntityComposer.this.recordBuilderFactory.getBuilder();
            }

            @Override
            public EntityComposer.Builder<E> put(String fieldName, Object value) {
                this.recordBuilder.put(fieldName, value);
                return this;
            }

            @Override
            public E build() {
                return (IndexedRecord)this.recordBuilder.build();
            }
        };
    }

    @Override
    public Object extractField(E entity, String fieldName) {
        ValidationException.check((this.accessor.getReadSchema().getField(fieldName) != null ? 1 : 0) != 0, (String)"No field named %s in schema %s", (Object[])new Object[]{fieldName, this.accessor.getReadSchema()});
        return this.accessor.get(entity, fieldName);
    }

    @Override
    public PartitionKey extractKey(PartitionStrategy strategy, E entity) {
        return PartitionKey.partitionKeyForEntity((PartitionStrategy)strategy, entity, this.accessor);
    }

    @Override
    public Map<CharSequence, Object> extractKeyAsColumnValues(String fieldName, Object fieldValue) {
        Schema schema = this.avroSchema.getAvroSchema();
        Schema.Field field = schema.getField(fieldName);
        if (field == null) {
            throw new ValidationException("No field named " + fieldName + " in schema " + schema);
        }
        if (field.schema().getType() == Schema.Type.MAP) {
            return new HashMap<CharSequence, Object>((Map)fieldValue);
        }
        if (field.schema().getType() == Schema.Type.RECORD) {
            HashMap<CharSequence, Object> keyAsColumnValues = new HashMap<CharSequence, Object>();
            IndexedRecord avroRecord = (IndexedRecord)fieldValue;
            for (Schema.Field avroRecordField : avroRecord.getSchema().getFields()) {
                keyAsColumnValues.put(avroRecordField.name(), avroRecord.get(avroRecordField.pos()));
            }
            return keyAsColumnValues;
        }
        throw new ValidationException("Only MAP or RECORD type valid for keyAsColumn fields. Found " + field.schema().getType());
    }

    @Override
    public Object buildKeyAsColumnField(String fieldName, Map<CharSequence, Object> keyAsColumnValues) {
        Schema schema = this.avroSchema.getAvroSchema();
        Schema.Field field = schema.getField(fieldName);
        if (field == null) {
            throw new ValidationException("No field named " + fieldName + " in schema " + schema);
        }
        Schema.Type fieldType = field.schema().getType();
        if (fieldType == Schema.Type.MAP) {
            HashMap<CharSequence, Object> retMap = new HashMap<CharSequence, Object>();
            for (Map.Entry<CharSequence, Object> entry : keyAsColumnValues.entrySet()) {
                retMap.put(entry.getKey(), entry.getValue());
            }
            return retMap;
        }
        if (fieldType == Schema.Type.RECORD) {
            AvroRecordBuilder<E> builder = this.kacRecordBuilderFactories.get(fieldName).getBuilder();
            for (Map.Entry<CharSequence, Object> keyAsColumnEntry : keyAsColumnValues.entrySet()) {
                builder.put(keyAsColumnEntry.getKey().toString(), keyAsColumnEntry.getValue());
            }
            return builder.build();
        }
        throw new ValidationException("Only MAP or RECORD type valid for keyAsColumn fields. Found " + fieldType);
    }

    private void initRecordBuilderFactories() {
        for (FieldMapping fieldMapping : this.avroSchema.getColumnMappingDescriptor().getFieldMappings()) {
            if (fieldMapping.getMappingType() != FieldMapping.MappingType.KEY_AS_COLUMN) continue;
            String fieldName = fieldMapping.getFieldName();
            Schema fieldSchema = this.avroSchema.getAvroSchema().getField(fieldName).schema();
            Schema.Type fieldSchemaType = fieldSchema.getType();
            if (fieldSchemaType != Schema.Type.RECORD) continue;
            AvroRecordBuilderFactory<E> factory = this.buildAvroRecordBuilderFactory(fieldSchema);
            this.kacRecordBuilderFactories.put(fieldName, factory);
        }
    }

    private AvroRecordBuilderFactory<E> buildAvroRecordBuilderFactory(Schema schema) {
        if (this.specific) {
            Class<?> specificClass;
            String className = schema.getFullName();
            try {
                specificClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DatasetException("Could not get Class instance for " + className);
            }
            return new SpecificAvroRecordBuilderFactory(specificClass);
        }
        return new GenericAvroRecordBuilderFactory(schema);
    }
}

