/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.example;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.hbase.avro.SpecificAvroDao;
import org.kitesdk.data.hbase.avro.example.UserActionsModel;
import org.kitesdk.data.hbase.avro.example.UserProfileActionsModel;
import org.kitesdk.data.hbase.avro.example.UserProfileModel;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.data.hbase.manager.DefaultSchemaManager;
import org.kitesdk.data.hbase.tool.SchemaTool;
import org.kitesdk.data.spi.PartitionKey;

public class UserProfileExample {
    private final Dao<UserProfileModel> userProfileDao;
    private final Dao<UserActionsModel> userActionsDao;
    private final Dao<UserProfileActionsModel> userProfileActionsDao;

    public UserProfileExample() throws InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        HTablePool pool = new HTablePool(conf, 10);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager(pool);
        this.registerSchemas(conf, schemaManager);
        this.userProfileDao = new SpecificAvroDao<UserProfileModel>(pool, "kite_example_user_profiles", "UserProfileModel", schemaManager);
        this.userActionsDao = new SpecificAvroDao<UserActionsModel>(pool, "kite_example_user_profiles", "UserActionsModel", schemaManager);
        this.userProfileActionsDao = SpecificAvroDao.buildCompositeDaoWithEntityManager(pool, "kite_example_user_profiles", UserProfileActionsModel.class, (SchemaManager)schemaManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printUserProfies() {
        EntityScanner<UserProfileModel> scanner = this.userProfileDao.getScanner();
        scanner.initialize();
        try {
            Iterator i$ = scanner.iterator();
            while (i$.hasNext()) {
                UserProfileModel entity = (UserProfileModel)((Object)i$.next());
                System.out.println(entity.toString());
            }
        }
        finally {
            scanner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printUserProfileActionsForLastName(String lastName) {
        PartitionKey startKey = new PartitionKey(new Object[]{"lastName"});
        EntityScanner<UserProfileActionsModel> scanner = this.userProfileActionsDao.getScanner(startKey, null);
        scanner.initialize();
        try {
            Iterator i$ = scanner.iterator();
            while (i$.hasNext()) {
                UserProfileActionsModel entity = (UserProfileActionsModel)((Object)i$.next());
                if (!entity.getUserProfileModel().getLastName().equals(lastName)) {
                    break;
                }
                System.out.println(entity.toString());
            }
        }
        finally {
            scanner.close();
        }
    }

    public void create(String firstName, String lastName, boolean married) {
        long ts = System.currentTimeMillis();
        UserProfileModel profileModel = UserProfileModel.newBuilder().setFirstName(firstName).setLastName(lastName).setMarried(married).setCreated(ts).build();
        UserActionsModel actionsModel = UserActionsModel.newBuilder().setFirstName(firstName).setLastName(lastName).setActions(new HashMap<String, String>()).build();
        actionsModel.getActions().put("profile_created", Long.toString(ts));
        UserProfileActionsModel profileActionsModel = UserProfileActionsModel.newBuilder().setUserProfileModel(profileModel).setUserActionsModel(actionsModel).build();
        if (!this.userProfileActionsDao.put(profileActionsModel)) {
            System.out.println("Creating a new user profile failed due to a write conflict.");
        }
    }

    public void updateUserProfile(String firstName, String lastName, boolean married) {
        long ts = System.currentTimeMillis();
        PartitionKey key = new PartitionKey(new Object[]{lastName, firstName});
        UserProfileActionsModel profileActionsModel = this.userProfileActionsDao.get(key);
        UserProfileActionsModel updatedProfileActionsModel = UserProfileActionsModel.newBuilder(profileActionsModel).setUserProfileModel(UserProfileModel.newBuilder(profileActionsModel.getUserProfileModel()).setMarried(married).build()).build();
        updatedProfileActionsModel.getUserActionsModel().getActions().put("profile_updated", Long.toString(ts));
        if (!this.userProfileActionsDao.put(updatedProfileActionsModel)) {
            System.out.println("Updating the user profile failed due to a write conflict");
        }
    }

    public void addAction(String firstName, String lastName, String actionType, String actionValue) {
        UserActionsModel actionsModel = UserActionsModel.newBuilder().setLastName(lastName).setFirstName(firstName).setActions(new HashMap<String, String>()).build();
        actionsModel.getActions().put(actionType, actionValue);
        this.userActionsDao.put(actionsModel);
    }

    private void registerSchemas(Configuration conf, SchemaManager schemaManager) throws InterruptedException {
        HBaseAdmin admin;
        try {
            admin = new HBaseAdmin(conf);
            if (admin.tableExists("kite_example_user_profiles")) {
                admin.disableTable("kite_example_user_profiles");
                admin.deleteTable("kite_example_user_profiles");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SchemaTool tool = new SchemaTool(admin, schemaManager);
        tool.createOrMigrateSchemaDirectory("classpath:example-models", true);
    }

    public static void main(String[] args) throws InterruptedException {
        UserProfileExample example = new UserProfileExample();
        example.create("John", "Doe", true);
        example.create("Jane", "Doe", false);
        example.create("Foo", "Bar", false);
        example.printUserProfies();
        example.addAction("Jane", "Doe", "last_login", "2013-07-30 00:00:00");
        example.addAction("Jane", "Doe", "ad_click", "example.com_ad_id");
        example.addAction("Foo", "Bar", "last_login", "2013-07-30 00:00:00");
        example.printUserProfileActionsForLastName("Doe");
        example.updateUserProfile("Jane", "Doe", true);
        example.printUserProfileActionsForLastName("Doe");
    }
}

