/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;

class TimeBucketMetrics<OBJ> {
    private final HashMap<OBJ, Long> map = new HashMap();
    private final int[] counts;
    private final long[] cuts;

    TimeBucketMetrics(long[] cuts) {
        this.cuts = cuts;
        this.counts = new int[cuts.length + 1];
    }

    synchronized void add(OBJ key, long time) {
        this.map.put(key, time);
    }

    synchronized void remove(OBJ key) {
        this.map.remove(key);
    }

    private int findBucket(long val) {
        for (int i = 0; i < this.cuts.length; ++i) {
            if (val >= this.cuts[i]) continue;
            return i;
        }
        return this.cuts.length;
    }

    synchronized int[] getBucketCounts(long now) {
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = 0;
        }
        for (Long time : this.map.values()) {
            int n = this.findBucket(now - time);
            this.counts[n] = this.counts[n] + 1;
        }
        return this.counts;
    }
}

