/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidAuxServiceException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.LogAggregationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.NonAggregatingLogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;

public class ContainerManagerImpl
extends CompositeService
implements ServiceStateChangeListener,
ContainerManagementProtocol,
EventHandler<ContainerManagerEvent> {
    private static final int SHUTDOWN_CLEANUP_SLOP_MS = 1000;
    private static final Log LOG = LogFactory.getLog(ContainerManagerImpl.class);
    final Context context;
    private final ContainersMonitor containersMonitor;
    private Server server;
    private final ResourceLocalizationService rsrcLocalizationSrvc;
    private final ContainersLauncher containersLauncher;
    private final AuxServices auxiliaryServices;
    private final NodeManagerMetrics metrics;
    private final NodeStatusUpdater nodeStatusUpdater;
    protected LocalDirsHandlerService dirsHandler;
    protected final AsyncDispatcher dispatcher;
    private final ApplicationACLsManager aclsManager;
    private final DeletionService deletionService;
    private AtomicBoolean blockNewContainerRequests = new AtomicBoolean(false);
    private boolean serviceStopped = false;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private long waitForContainersOnShutdownMillis;

    public ContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(ContainerManagerImpl.class.getName());
        this.context = context;
        this.dirsHandler = dirsHandler;
        this.dispatcher = new AsyncDispatcher();
        this.deletionService = deletionContext;
        this.metrics = metrics;
        this.rsrcLocalizationSrvc = this.createResourceLocalizationService(exec, deletionContext, context);
        this.addService((Service)this.rsrcLocalizationSrvc);
        this.containersLauncher = this.createContainersLauncher(context, exec);
        this.addService((Service)this.containersLauncher);
        this.nodeStatusUpdater = nodeStatusUpdater;
        this.aclsManager = aclsManager;
        this.auxiliaryServices = new AuxServices();
        this.auxiliaryServices.registerServiceListener(this);
        this.addService((Service)this.auxiliaryServices);
        this.containersMonitor = new ContainersMonitorImpl(exec, this.dispatcher, this.context);
        this.addService(this.containersMonitor);
        this.dispatcher.register(ContainerEventType.class, (EventHandler)new ContainerEventDispatcher());
        this.dispatcher.register(ApplicationEventType.class, (EventHandler)new ApplicationEventDispatcher());
        this.dispatcher.register(LocalizationEventType.class, (EventHandler)this.rsrcLocalizationSrvc);
        this.dispatcher.register(AuxServicesEventType.class, (EventHandler)this.auxiliaryServices);
        this.dispatcher.register(ContainersMonitorEventType.class, (EventHandler)this.containersMonitor);
        this.dispatcher.register(ContainersLauncherEventType.class, (EventHandler)this.containersLauncher);
        this.addService((Service)this.dispatcher);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void serviceInit(Configuration conf) throws Exception {
        LogHandler logHandler = this.createLogHandler(conf, this.context, this.deletionService);
        this.addIfService(logHandler);
        this.dispatcher.register(LogHandlerEventType.class, (EventHandler)logHandler);
        this.waitForContainersOnShutdownMillis = conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L) + 1000L;
        super.serviceInit(conf);
        this.recover();
    }

    private void recover() throws IOException, URISyntaxException {
        NMStateStoreService stateStore = this.context.getNMStateStore();
        if (stateStore.canRecover()) {
            this.rsrcLocalizationSrvc.recoverLocalizedResources(stateStore.loadLocalizationState());
            NMStateStoreService.RecoveredApplicationsState appsState = stateStore.loadApplicationsState();
            for (YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto proto : appsState.getApplications()) {
                this.recoverApplication(proto);
            }
            for (NMStateStoreService.RecoveredContainerState rcs : stateStore.loadContainersState()) {
                this.recoverContainer(rcs);
            }
            String diagnostic = "Application marked finished during recovery";
            for (ApplicationId appId : appsState.getFinishedApplications()) {
                this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appId, diagnostic));
            }
        }
    }

    private void recoverApplication(YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto p) throws IOException {
        ApplicationIdPBImpl appId = new ApplicationIdPBImpl(p.getId());
        Credentials creds = new Credentials();
        creds.readTokenStorageStream(new DataInputStream(p.getCredentials().newInput()));
        List<YarnProtos.ApplicationACLMapProto> aclProtoList = p.getAclsList();
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(aclProtoList.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : aclProtoList) {
            acls.put(ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationAccessTypeProto)aclProto.getAccessType()), aclProto.getAcl());
        }
        LogAggregationContextPBImpl logAggregationContext = null;
        if (p.getLogAggregationContext() != null) {
            logAggregationContext = new LogAggregationContextPBImpl(p.getLogAggregationContext());
        }
        LOG.info((Object)("Recovering application " + appId));
        ApplicationImpl app = new ApplicationImpl((Dispatcher)this.dispatcher, p.getUser(), (ApplicationId)appId, creds, this.context);
        this.context.getApplications().put((ApplicationId)appId, app);
        app.handle(new ApplicationInitEvent((ApplicationId)appId, acls, (LogAggregationContext)logAggregationContext));
    }

    private void recoverContainer(NMStateStoreService.RecoveredContainerState rcs) throws IOException {
        StartContainerRequest req = rcs.getStartRequest();
        ContainerLaunchContext launchContext = req.getContainerLaunchContext();
        ContainerTokenIdentifier token = BuilderUtils.newContainerTokenIdentifier((org.apache.hadoop.yarn.api.records.Token)req.getContainerToken());
        ContainerId containerId = token.getContainerID();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        LOG.info((Object)("Recovering " + containerId + " in state " + (Object)((Object)rcs.getStatus()) + " with exit code " + rcs.getExitCode()));
        if (this.context.getApplications().containsKey(appId)) {
            Credentials credentials = this.parseCredentials(launchContext);
            ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, this.context.getNMStateStore(), req.getContainerLaunchContext(), credentials, this.metrics, token, rcs.getStatus(), rcs.getExitCode(), rcs.getDiagnostics(), rcs.getKilled());
            this.context.getContainers().put(containerId, container);
            this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
        } else {
            if (rcs.getStatus() != NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                LOG.warn((Object)(containerId + " has no corresponding application!"));
            }
            LOG.info((Object)("Adding " + containerId + " to recently stopped containers"));
            this.nodeStatusUpdater.addCompletedContainer(containerId);
        }
    }

    private void waitForRecoveredContainers() throws InterruptedException {
        int sleepMsec = 100;
        int waitIterations = 100;
        ArrayList<ContainerId> newContainers = new ArrayList<ContainerId>();
        while (--waitIterations >= 0) {
            newContainers.clear();
            for (Container container : this.context.getContainers().values()) {
                if (container.getContainerState() != ContainerState.NEW) continue;
                newContainers.add(container.getContainerId());
            }
            if (newContainers.isEmpty()) break;
            LOG.info((Object)("Waiting for containers: " + newContainers));
            Thread.sleep(100L);
        }
        if (waitIterations < 0) {
            LOG.warn((Object)"Timeout waiting for recovered containers");
        }
    }

    protected LogHandler createLogHandler(Configuration conf, Context context, DeletionService deletionService) {
        if (conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return new LogAggregationService((Dispatcher)this.dispatcher, context, deletionService, this.dirsHandler);
        }
        return new NonAggregatingLogHandler((Dispatcher)this.dispatcher, deletionService, this.dirsHandler);
    }

    public ContainersMonitor getContainersMonitor() {
        return this.containersMonitor;
    }

    protected ResourceLocalizationService createResourceLocalizationService(ContainerExecutor exec, DeletionService deletionContext, Context context) {
        return new ResourceLocalizationService((Dispatcher)this.dispatcher, exec, deletionContext, this.dirsHandler, context);
    }

    protected ContainersLauncher createContainersLauncher(Context context, ContainerExecutor exec) {
        return new ContainersLauncher(context, (Dispatcher)this.dispatcher, exec, this.dirsHandler, this);
    }

    protected void serviceStart() throws Exception {
        InetSocketAddress connectAddress;
        boolean usingEphemeralPort;
        Configuration conf = this.getConfig();
        InetSocketAddress initialAddress = conf.getSocketAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.address", "0.0.0.0:0", 0);
        boolean bl = usingEphemeralPort = initialAddress.getPort() == 0;
        if (this.context.getNMStateStore().canRecover() && usingEphemeralPort) {
            throw new IllegalArgumentException("Cannot support recovery with an ephemeral server port. Check the setting of yarn.nodemanager.address");
        }
        boolean delayedRpcServerStart = this.context.getNMStateStore().canRecover();
        Configuration serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ContainerManagementProtocol.class, (Object)this, initialAddress, serverConf, (SecretManager)this.context.getNMTokenSecretManager(), conf.getInt("yarn.nodemanager.container-manager.thread-count", 20));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new NMPolicyProvider());
        }
        LOG.info((Object)"Blocking new container-requests as container manager rpc server is still starting.");
        this.setBlockNewContainerRequests(true);
        String bindHost = conf.get("yarn.nodemanager.bind-host");
        String nmAddress = conf.getTrimmed("yarn.nodemanager.address");
        String hostOverride = null;
        if (bindHost != null && !bindHost.isEmpty() && nmAddress != null && !nmAddress.isEmpty()) {
            hostOverride = nmAddress.split(":")[0];
        }
        if (delayedRpcServerStart) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)initialAddress);
        } else {
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
        }
        NodeId nodeId = this.buildNodeId(connectAddress, hostOverride);
        ((NodeManager.NMContext)this.context).setNodeId(nodeId);
        this.context.getNMTokenSecretManager().setNodeId(nodeId);
        this.context.getContainerTokenSecretManager().setNodeId(nodeId);
        super.serviceStart();
        if (delayedRpcServerStart) {
            this.waitForRecoveredContainers();
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
            NodeId serverNode = this.buildNodeId(connectAddress, hostOverride);
            if (!serverNode.equals((Object)nodeId)) {
                throw new IOException("Node mismatch after server started, expected '" + nodeId + "' but found '" + serverNode + "'");
            }
        }
        LOG.info((Object)("ContainerManager started at " + connectAddress));
        LOG.info((Object)("ContainerManager bound to " + initialAddress));
    }

    private NodeId buildNodeId(InetSocketAddress connectAddress, String hostOverride) {
        if (hostOverride != null) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)new InetSocketAddress(hostOverride, connectAddress.getPort()));
        }
        return NodeId.newInstance((String)connectAddress.getAddress().getCanonicalHostName(), (int)connectAddress.getPort());
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        this.setBlockNewContainerRequests(true);
        this.writeLock.lock();
        try {
            this.serviceStopped = true;
            if (this.context != null) {
                this.cleanUpApplicationsOnNMShutDown();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.auxiliaryServices.getServiceState() == Service.STATE.STARTED) {
            this.auxiliaryServices.unregisterServiceListener(this);
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    public void cleanUpApplicationsOnNMShutDown() {
        ConcurrentMap<ApplicationId, Application> applications = this.context.getApplications();
        if (applications.isEmpty()) {
            return;
        }
        LOG.info((Object)("Applications still running : " + applications.keySet()));
        if (this.context.getNMStateStore().canRecover() && !this.context.getDecommissioned()) {
            return;
        }
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>(applications.keySet());
        this.handle(new CMgrCompletedAppsEvent(appIds, CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN));
        LOG.info((Object)"Waiting for Applications to be Finished");
        long waitStartTime = System.currentTimeMillis();
        while (!applications.isEmpty() && System.currentTimeMillis() - waitStartTime < this.waitForContainersOnShutdownMillis) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Interrupted while sleeping on applications finish on shutdown", (Throwable)ex);
            }
        }
        if (applications.isEmpty()) {
            LOG.info((Object)"All applications in FINISHED state");
        } else {
            LOG.info((Object)("Done waiting for Applications to be Finished. Still alive: " + applications.keySet()));
        }
    }

    public void cleanupContainersOnNMResync() {
        ConcurrentMap<ContainerId, Container> containers = this.context.getContainers();
        if (containers.isEmpty()) {
            return;
        }
        LOG.info((Object)("Containers still running on " + (Object)((Object)CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC) + " : " + containers.keySet()));
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>(containers.keySet());
        LOG.info((Object)"Waiting for containers to be killed");
        this.handle(new CMgrCompletedContainersEvent(containerIds, CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC));
        boolean allContainersCompleted = false;
        block2: while (!containers.isEmpty() && !allContainersCompleted) {
            allContainersCompleted = true;
            for (Map.Entry container : containers.entrySet()) {
                if (((ContainerImpl)container.getValue()).getCurrentState() == org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE) continue;
                allContainersCompleted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Interrupted while sleeping on container kill on resync", (Throwable)ex);
                }
                continue block2;
            }
        }
        if (allContainersCompleted) {
            LOG.info((Object)"All containers in DONE state");
        } else {
            LOG.info((Object)("Done waiting for containers to be killed. Still alive: " + containers.keySet()));
        }
    }

    protected UserGroupInformation getRemoteUgi() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        return remoteUgi;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMTokenIdentifier selectNMTokenIdentifier(UserGroupInformation remoteUgi) {
        Set tokenIdentifiers = remoteUgi.getTokenIdentifiers();
        NMTokenIdentifier resultId = null;
        for (TokenIdentifier id : tokenIdentifiers) {
            if (!(id instanceof NMTokenIdentifier)) continue;
            resultId = (NMTokenIdentifier)id;
            break;
        }
        return resultId;
    }

    protected void authorizeUser(UserGroupInformation remoteUgi, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        if (!remoteUgi.getUserName().equals(nmTokenIdentifier.getApplicationAttemptId().toString())) {
            throw RPCUtil.getRemoteException((String)("Expected applicationAttemptId: " + remoteUgi.getUserName() + "Found: " + nmTokenIdentifier.getApplicationAttemptId()));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeStartRequest(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException {
        ContainerId containerId = containerTokenIdentifier.getContainerID();
        String containerIDStr = containerId.toString();
        boolean unauthorized = false;
        StringBuilder messageBuilder = new StringBuilder("Unauthorized request to start container. ");
        if (!nmTokenIdentifier.getApplicationAttemptId().getApplicationId().equals((Object)containerId.getApplicationAttemptId().getApplicationId())) {
            unauthorized = true;
            messageBuilder.append("\nNMToken for application attempt : ").append(nmTokenIdentifier.getApplicationAttemptId()).append(" was used for starting container with container token").append(" issued for application attempt : ").append(containerId.getApplicationAttemptId());
        } else if (!this.context.getContainerTokenSecretManager().isValidStartContainerRequest(containerTokenIdentifier)) {
            unauthorized = true;
            messageBuilder.append("\n Attempt to relaunch the same ").append("container with id ").append(containerIDStr).append(".");
        } else if (containerTokenIdentifier.getExpiryTimeStamp() < System.currentTimeMillis()) {
            unauthorized = true;
            messageBuilder.append("\nThis token is expired. current time is ").append(System.currentTimeMillis()).append(" found ").append(containerTokenIdentifier.getExpiryTimeStamp());
            messageBuilder.append("\nNote: System times on machines may be out of sync.").append(" Check system time and time zones.");
        }
        if (unauthorized) {
            String msg = messageBuilder.toString();
            LOG.error((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
    }

    public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException, IOException {
        if (this.blockNewContainerRequests.get()) {
            throw new NMNotYetReadyException("Rejecting new containers as NodeManager has not yet connected with ResourceManager");
        }
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        ArrayList<ContainerId> succeededContainers = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedContainers = new HashMap<ContainerId, SerializedException>();
        for (StartContainerRequest request : requests.getStartContainerRequests()) {
            ContainerId containerId = null;
            try {
                ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((org.apache.hadoop.yarn.api.records.Token)request.getContainerToken());
                this.verifyAndGetContainerTokenIdentifier(request.getContainerToken(), containerTokenIdentifier);
                containerId = containerTokenIdentifier.getContainerID();
                this.startContainerInternal(nmTokenIdentifier, containerTokenIdentifier, request);
                succeededContainers.add(containerId);
            }
            catch (YarnException e) {
                failedContainers.put(containerId, SerializedException.newInstance((Throwable)e));
            }
            catch (SecretManager.InvalidToken ie) {
                failedContainers.put(containerId, SerializedException.newInstance((Throwable)ie));
                throw ie;
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
        }
        return StartContainersResponse.newInstance(this.getAuxServiceMetaData(), succeededContainers, failedContainers);
    }

    private YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto buildAppProto(ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext) {
        YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.Builder builder = YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.newBuilder();
        builder.setId(((ApplicationIdPBImpl)appId).getProto());
        builder.setUser(user);
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        builder.clearCredentials();
        if (credentials != null) {
            DataOutputBuffer dob = new DataOutputBuffer();
            try {
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
                builder.setCredentials(ByteString.copyFrom((byte[])dob.getData()));
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot serialize credentials", (Throwable)e);
            }
        }
        builder.clearAcls();
        if (appAcls != null) {
            for (Map.Entry<ApplicationAccessType, String> acl : appAcls.entrySet()) {
                YarnProtos.ApplicationACLMapProto p = YarnProtos.ApplicationACLMapProto.newBuilder().setAccessType(ProtoUtils.convertToProtoFormat((ApplicationAccessType)acl.getKey())).setAcl(acl.getValue()).build();
                builder.addAcls(p);
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainerInternal(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier, StartContainerRequest request) throws YarnException, IOException {
        block9: {
            this.authorizeStartRequest(nmTokenIdentifier, containerTokenIdentifier);
            if (containerTokenIdentifier.getRMIdentifer() != this.nodeStatusUpdater.getRMIdentifier()) {
                StringBuilder sb = new StringBuilder("\nContainer ");
                sb.append(containerTokenIdentifier.getContainerID().toString()).append(" rejected as it is allocated by a previous RM");
                throw new InvalidContainerException(sb.toString());
            }
            this.updateNMTokenIdentifier(nmTokenIdentifier);
            ContainerId containerId = containerTokenIdentifier.getContainerID();
            String containerIdStr = containerId.toString();
            String user = containerTokenIdentifier.getApplicationSubmitter();
            LOG.info((Object)("Start request for " + containerIdStr + " by user " + user));
            ContainerLaunchContext launchContext = request.getContainerLaunchContext();
            Map<String, ByteBuffer> serviceData = this.getAuxServiceMetaData();
            if (launchContext.getServiceData() != null && !launchContext.getServiceData().isEmpty()) {
                for (Map.Entry meta : launchContext.getServiceData().entrySet()) {
                    if (null != serviceData.get(meta.getKey())) continue;
                    throw new InvalidAuxServiceException("The auxService:" + (String)meta.getKey() + " does not exist");
                }
            }
            Credentials credentials = this.parseCredentials(launchContext);
            ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, this.context.getNMStateStore(), launchContext, credentials, this.metrics, containerTokenIdentifier);
            ApplicationId applicationID = containerId.getApplicationAttemptId().getApplicationId();
            if (this.context.getContainers().putIfAbsent(containerId, container) != null) {
                NMAuditLogger.logFailure(user, "Start Container Request", "ContainerManagerImpl", "Container already running on this node!", applicationID, containerId);
                throw RPCUtil.getRemoteException((String)("Container " + containerIdStr + " already is running on this node!!"));
            }
            this.readLock.lock();
            try {
                if (!this.serviceStopped) {
                    ApplicationImpl application = new ApplicationImpl((Dispatcher)this.dispatcher, user, applicationID, credentials, this.context);
                    if (null == this.context.getApplications().putIfAbsent(applicationID, application)) {
                        LOG.info((Object)("Creating a new application reference for app " + applicationID));
                        LogAggregationContext logAggregationContext = containerTokenIdentifier.getLogAggregationContext();
                        Map appAcls = container.getLaunchContext().getApplicationACLs();
                        this.context.getNMStateStore().storeApplication(applicationID, this.buildAppProto(applicationID, user, credentials, appAcls, logAggregationContext));
                        this.dispatcher.getEventHandler().handle((Event)new ApplicationInitEvent(applicationID, appAcls, logAggregationContext));
                    }
                    this.context.getNMStateStore().storeContainer(containerId, request);
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
                    this.context.getContainerTokenSecretManager().startContainerSuccessful(containerTokenIdentifier);
                    NMAuditLogger.logSuccess(user, "Start Container Request", "ContainerManageImpl", applicationID, containerId);
                    this.metrics.launchedContainer();
                    this.metrics.allocateContainer(containerTokenIdentifier.getResource());
                    break block9;
                }
                throw new YarnException("Container start failed as the NodeManager is in the process of shutting down");
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    protected ContainerTokenIdentifier verifyAndGetContainerTokenIdentifier(org.apache.hadoop.yarn.api.records.Token token, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException, SecretManager.InvalidToken {
        byte[] password = this.context.getContainerTokenSecretManager().retrievePassword(containerTokenIdentifier);
        byte[] tokenPass = token.getPassword().array();
        if (password == null || tokenPass == null || !Arrays.equals(password, tokenPass)) {
            throw new SecretManager.InvalidToken("Invalid container token used for starting container on : " + this.context.getNodeId().toString());
        }
        return containerTokenIdentifier;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void updateNMTokenIdentifier(NMTokenIdentifier nmTokenIdentifier) throws SecretManager.InvalidToken {
        this.context.getNMTokenSecretManager().appAttemptStartContainer(nmTokenIdentifier);
    }

    private Credentials parseCredentials(ContainerLaunchContext launchContext) throws IOException {
        Credentials credentials = new Credentials();
        ByteBuffer tokens = launchContext.getTokens();
        if (tokens != null) {
            DataInputByteBuffer buf = new DataInputByteBuffer();
            tokens.rewind();
            buf.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)buf);
            if (LOG.isDebugEnabled()) {
                for (Token tk : credentials.getAllTokens()) {
                    LOG.debug((Object)(tk.getService() + " = " + tk.toString()));
                }
            }
        }
        return credentials;
    }

    public StopContainersResponse stopContainers(StopContainersRequest requests) throws YarnException, IOException {
        ArrayList<ContainerId> succeededRequests = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        for (ContainerId id : requests.getContainerIds()) {
            try {
                this.stopContainerInternal(identifier, id);
                succeededRequests.add(id);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return StopContainersResponse.newInstance(succeededRequests, failedRequests);
    }

    private void stopContainerInternal(NMTokenIdentifier nmTokenIdentifier, ContainerId containerID) throws YarnException, IOException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Stopping container with container Id: " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, true, nmTokenIdentifier);
        if (container == null) {
            if (!this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
            }
        } else {
            this.context.getNMStateStore().storeContainerKilled(containerID);
            this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, -105, "Container killed by the ApplicationMaster."));
            NMAuditLogger.logSuccess(container.getUser(), "Stop Container Request", "ContainerManageImpl", containerID.getApplicationAttemptId().getApplicationId(), containerID);
            this.nodeStatusUpdater.sendOutofBandHeartBeat();
        }
    }

    public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException, IOException {
        ArrayList<ContainerStatus> succeededRequests = new ArrayList<ContainerStatus>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        for (ContainerId id : request.getContainerIds()) {
            try {
                ContainerStatus status = this.getContainerStatusInternal(id, identifier);
                succeededRequests.add(status);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return GetContainerStatusesResponse.newInstance(succeededRequests, failedRequests);
    }

    private ContainerStatus getContainerStatusInternal(ContainerId containerID, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Getting container-status for " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, false, nmTokenIdentifier);
        if (container == null) {
            if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " was recently stopped on node manager."));
            }
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
        }
        ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
        LOG.info((Object)("Returning " + containerStatus));
        return containerStatus;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeGetAndStopContainerRequest(ContainerId containerId, Container container, boolean stopRequest, NMTokenIdentifier identifier) throws YarnException {
        ApplicationId nmTokenAppId = identifier.getApplicationAttemptId().getApplicationId();
        if (!nmTokenAppId.equals((Object)containerId.getApplicationAttemptId().getApplicationId()) || container != null && !nmTokenAppId.equals((Object)container.getContainerId().getApplicationAttemptId().getApplicationId())) {
            if (stopRequest) {
                LOG.warn((Object)(identifier.getApplicationAttemptId() + " attempted to stop non-application container : " + container.getContainerId()));
                NMAuditLogger.logFailure("UnknownUser", "Stop Container Request", "ContainerManagerImpl", "Trying to stop unknown container!", nmTokenAppId, container.getContainerId());
            } else {
                LOG.warn((Object)(identifier.getApplicationAttemptId() + " attempted to get status for non-application container : " + container.getContainerId()));
            }
        }
    }

    public void handle(ContainerManagerEvent event) {
        switch ((ContainerManagerEventType)event.getType()) {
            case FINISH_APPS: {
                CMgrCompletedAppsEvent appsFinishedEvent = (CMgrCompletedAppsEvent)event;
                for (ApplicationId appID : appsFinishedEvent.getAppsToCleanup()) {
                    String diagnostic = "";
                    if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN) {
                        diagnostic = "Application killed on shutdown";
                    } else if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.BY_RESOURCEMANAGER) {
                        diagnostic = "Application killed by ResourceManager";
                    }
                    try {
                        this.context.getNMStateStore().storeFinishedApplication(appID);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to update application state in store", (Throwable)e);
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appID, diagnostic));
                }
                break;
            }
            case FINISH_CONTAINERS: {
                CMgrCompletedContainersEvent containersFinishedEvent = (CMgrCompletedContainersEvent)event;
                for (ContainerId container : containersFinishedEvent.getContainersToCleanup()) {
                    this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(container, -106, "Container Killed by ResourceManager"));
                }
                break;
            }
            default: {
                throw new YarnRuntimeException("Got an unknown ContainerManagerEvent type: " + event.getType());
            }
        }
    }

    public void setBlockNewContainerRequests(boolean blockNewContainerRequests) {
        this.blockNewContainerRequests.set(blockNewContainerRequests);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean getBlockNewContainerRequestsStatus() {
        return this.blockNewContainerRequests.get();
    }

    public void stateChanged(Service service) {
    }

    public Context getContext() {
        return this.context;
    }

    public Map<String, ByteBuffer> getAuxServiceMetaData() {
        return this.auxiliaryServices.getMetaData();
    }

    class ApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        ApplicationEventDispatcher() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(event.getApplicationID());
            if (app != null) {
                app.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID()));
            }
        }
    }

    class ContainerEventDispatcher
    implements EventHandler<ContainerEvent> {
        ContainerEventDispatcher() {
        }

        public void handle(ContainerEvent event) {
            ConcurrentMap<ContainerId, Container> containers = ContainerManagerImpl.this.context.getContainers();
            Container c = (Container)containers.get(event.getContainerID());
            if (c != null) {
                c.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent container " + event.getContainerID()));
            }
        }
    }
}

