/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.yarn.api.records.ContainerId;

@InterfaceAudience.Private
@Metrics(context="container")
public class ContainerMetrics
implements MetricsSource {
    public static final String PMEM_LIMIT_METRIC_NAME = "pMemLimitMBs";
    public static final String VMEM_LIMIT_METRIC_NAME = "vMemLimitMBs";
    public static final String VCORE_LIMIT_METRIC_NAME = "vCoreLimit";
    public static final String PMEM_USAGE_METRIC_NAME = "pMemUsageMBs";
    public static final String LAUNCH_DURATION_METRIC_NAME = "launchDurationMs";
    public static final String LOCALIZATION_DURATION_METRIC_NAME = "localizationDurationMs";
    private static final String PHY_CPU_USAGE_METRIC_NAME = "pCpuUsagePercent";
    private static final String VCORE_USAGE_METRIC_NAME = "milliVcoreUsage";
    @Metric
    public MutableStat pMemMBsStat;
    @Metric
    public MutableStat cpuCoreUsagePercent;
    @Metric
    public MutableStat milliVcoresUsed;
    @Metric
    public MutableGaugeInt pMemLimitMbs;
    @Metric
    public MutableGaugeInt vMemLimitMbs;
    @Metric
    public MutableGaugeInt cpuVcoreLimit;
    @Metric
    public MutableGaugeLong launchDurationMs;
    @Metric
    public MutableGaugeLong localizationDurationMs;
    static final MetricsInfo RECORD_INFO = Interns.info((String)"ContainerResource", (String)"Resource limit and usage by container");
    public static final MetricsInfo PROCESSID_INFO = Interns.info((String)"ContainerPid", (String)"Container Process Id");
    final MetricsInfo recordInfo;
    final MetricsRegistry registry;
    final ContainerId containerId;
    final MetricsSystem metricsSystem;
    private long flushPeriodMs;
    private boolean flushOnPeriod = false;
    private boolean finished = false;
    private boolean unregister = false;
    private Timer timer;
    protected static final Map<ContainerId, ContainerMetrics> usageMetrics = new HashMap<ContainerId, ContainerMetrics>();

    ContainerMetrics(MetricsSystem ms, ContainerId containerId, long flushPeriodMs) {
        this.recordInfo = Interns.info((String)ContainerMetrics.sourceName(containerId), (String)RECORD_INFO.description());
        this.registry = new MetricsRegistry(this.recordInfo);
        this.metricsSystem = ms;
        this.containerId = containerId;
        this.flushPeriodMs = flushPeriodMs;
        this.scheduleTimerTaskIfRequired();
        this.pMemMBsStat = this.registry.newStat(PMEM_USAGE_METRIC_NAME, "Physical memory stats", "Usage", "MBs", true);
        this.cpuCoreUsagePercent = this.registry.newStat(PHY_CPU_USAGE_METRIC_NAME, "Physical Cpu core percent usage stats", "Usage", "Percents", true);
        this.milliVcoresUsed = this.registry.newStat(VCORE_USAGE_METRIC_NAME, "1000 times Vcore usage", "Usage", "MilliVcores", true);
        this.pMemLimitMbs = this.registry.newGauge(PMEM_LIMIT_METRIC_NAME, "Physical memory limit in MBs", 0);
        this.vMemLimitMbs = this.registry.newGauge(VMEM_LIMIT_METRIC_NAME, "Virtual memory limit in MBs", 0);
        this.cpuVcoreLimit = this.registry.newGauge(VCORE_LIMIT_METRIC_NAME, "CPU limit in number of vcores", 0);
        this.launchDurationMs = this.registry.newGauge(LAUNCH_DURATION_METRIC_NAME, "Launch duration in MS", 0L);
        this.localizationDurationMs = this.registry.newGauge(LOCALIZATION_DURATION_METRIC_NAME, "Localization duration in MS", 0L);
    }

    ContainerMetrics tag(MetricsInfo info, ContainerId containerId) {
        this.registry.tag(info, containerId.toString());
        return this;
    }

    static String sourceName(ContainerId containerId) {
        return RECORD_INFO.name() + "_" + containerId.toString();
    }

    public static ContainerMetrics forContainer(ContainerId containerId, long flushPeriodMs) {
        return ContainerMetrics.forContainer(DefaultMetricsSystem.instance(), containerId, flushPeriodMs);
    }

    static synchronized ContainerMetrics forContainer(MetricsSystem ms, ContainerId containerId, long flushPeriodMs) {
        ContainerMetrics metrics = usageMetrics.get(containerId);
        if (metrics == null) {
            metrics = new ContainerMetrics(ms, containerId, flushPeriodMs).tag(RECORD_INFO, containerId);
            if (ms != null) {
                metrics = (ContainerMetrics)ms.register(ContainerMetrics.sourceName(containerId), "Metrics for container: " + containerId, (Object)metrics);
            }
            usageMetrics.put(containerId, metrics);
        }
        return metrics;
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        if (this.unregister) {
            this.metricsSystem.unregisterSource(this.recordInfo.name());
            usageMetrics.remove(this.containerId);
            return;
        }
        if (this.finished || this.flushOnPeriod) {
            this.registry.snapshot(collector.addRecord(this.registry.info()), all);
        }
        if (this.finished) {
            this.unregister = true;
        } else if (this.flushOnPeriod) {
            this.flushOnPeriod = false;
            this.scheduleTimerTaskIfRequired();
        }
    }

    public synchronized void finished() {
        this.finished = true;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void recordMemoryUsage(int memoryMBs) {
        this.pMemMBsStat.add((long)memoryMBs);
    }

    public void recordCpuUsage(int totalPhysicalCpuPercent, int milliVcoresUsed) {
        this.cpuCoreUsagePercent.add((long)totalPhysicalCpuPercent);
        this.milliVcoresUsed.add((long)milliVcoresUsed);
    }

    public void recordProcessId(String processId) {
        this.registry.tag(PROCESSID_INFO, processId);
    }

    public void recordResourceLimit(int vmemLimit, int pmemLimit, int cpuVcores) {
        this.vMemLimitMbs.set(vmemLimit);
        this.pMemLimitMbs.set(pmemLimit);
        this.cpuVcoreLimit.set(cpuVcores);
    }

    public void recordStateChangeDurations(long launchDuration, long localizationDuration) {
        this.launchDurationMs.set(launchDuration);
        this.localizationDurationMs.set(localizationDuration);
    }

    private synchronized void scheduleTimerTaskIfRequired() {
        if (this.flushPeriodMs > 0L) {
            if (this.timer == null) {
                this.timer = new Timer("Metrics flush checker", true);
            }
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ContainerMetrics containerMetrics = ContainerMetrics.this;
                    synchronized (containerMetrics) {
                        if (!ContainerMetrics.this.finished) {
                            ContainerMetrics.this.flushOnPeriod = true;
                        }
                    }
                }
            };
            this.timer.schedule(timerTask, this.flushPeriodMs);
        }
    }
}

