/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

class FlumeEventPointer {
    private final int fileID;
    private final int offset;

    FlumeEventPointer(int fileID, int offset) {
        this.fileID = fileID;
        this.offset = offset;
        if (offset < 0) {
            throw new IllegalArgumentException("offset = " + offset + "(" + Integer.toHexString(offset) + ")" + ", fileID = " + fileID + "(" + Integer.toHexString(fileID) + ")");
        }
    }

    int getFileID() {
        return this.fileID;
    }

    int getOffset() {
        return this.offset;
    }

    public long toLong() {
        long result = this.fileID;
        result = (long)this.fileID << 32;
        return result += (long)this.offset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fileID;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlumeEventPointer other = (FlumeEventPointer)obj;
        if (this.fileID != other.fileID) {
            return false;
        }
        return this.offset == other.offset;
    }

    public String toString() {
        return "FlumeEventPointer [fileID=" + this.fileID + ", offset=" + this.offset + "]";
    }

    public static FlumeEventPointer fromLong(long value) {
        int fileID = (int)(value >>> 32);
        int offset = (int)value;
        return new FlumeEventPointer(fileID, offset);
    }
}

