/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.encryption;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEFileKeyProvider
extends KeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(JCEFileKeyProvider.class);
    private Map<String, File> aliasPasswordFileMap;
    private KeyStore ks;
    private char[] keyStorePassword;
    private File keyStorePasswordFile;

    public JCEFileKeyProvider(File keyStoreFile, File keyStorePasswordFile, Map<String, File> aliasPasswordFileMap) {
        this.aliasPasswordFileMap = aliasPasswordFileMap;
        this.keyStorePasswordFile = keyStorePasswordFile;
        try {
            this.ks = KeyStore.getInstance("jceks");
            this.keyStorePassword = Files.toString((File)keyStorePasswordFile, (Charset)Charsets.UTF_8).trim().toCharArray();
            this.ks.load(new FileInputStream(keyStoreFile), this.keyStorePassword);
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public Key getKey(String alias) {
        String passwordFile = this.keyStorePasswordFile.getAbsolutePath();
        try {
            Key key;
            char[] keyPassword = this.keyStorePassword;
            if (this.aliasPasswordFileMap.containsKey(alias)) {
                File keyPasswordFile = this.aliasPasswordFileMap.get(alias);
                keyPassword = Files.toString((File)keyPasswordFile, (Charset)Charsets.UTF_8).trim().toCharArray();
                passwordFile = keyPasswordFile.getAbsolutePath();
            }
            if ((key = this.ks.getKey(alias, keyPassword)) == null) {
                throw new IllegalStateException("KeyStore returned null for " + alias);
            }
            return key;
        }
        catch (Exception e) {
            String msg = e.getClass().getName() + ": " + e.getMessage() + ". " + "Key = " + alias + ", passwordFile = " + passwordFile;
            throw new RuntimeException(msg, e);
        }
    }

    public static class Builder
    implements KeyProvider.Builder {
        @Override
        public KeyProvider build(Context context) {
            String keyStoreFileName = context.getString("keyStoreFile");
            String keyStorePasswordFileName = context.getString("keyStorePasswordFile");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)keyStoreFileName) ? 1 : 0) != 0, (Object)"KeyStore file not specified");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)keyStorePasswordFileName) ? 1 : 0) != 0, (Object)"KeyStore password  file not specified");
            HashMap aliasPasswordFileMap = Maps.newHashMap();
            String passwordProtectedKeys = context.getString("keys");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)passwordProtectedKeys) ? 1 : 0) != 0, (Object)"Keys available to KeyStore was not specified or empty");
            for (String passwordName : passwordProtectedKeys.trim().split("\\s+")) {
                String propertyName = Joiner.on((String)".").join((Object)"keys", (Object)passwordName, new Object[]{"passwordFile"});
                String passwordFileName = context.getString(propertyName, keyStorePasswordFileName);
                File passwordFile = new File(passwordFileName.trim());
                if (passwordFile.isFile()) {
                    aliasPasswordFileMap.put(passwordName, passwordFile);
                    continue;
                }
                logger.warn("Password file for alias " + passwordName + " does not exist");
            }
            File keyStoreFile = new File(keyStoreFileName.trim());
            File keyStorePasswordFile = new File(keyStorePasswordFileName.trim());
            return new JCEFileKeyProvider(keyStoreFile, keyStorePasswordFile, aliasPasswordFileMap);
        }
    }
}

