/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CopyTable
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyTable.class);
    static final String NAME = "copytable";
    long startTime = 0L;
    long endTime = 0L;
    int versions = -1;
    String tableName = null;
    String startRow = null;
    String stopRow = null;
    String dstTableName = null;
    String peerAddress = null;
    String families = null;
    boolean allCells = false;
    static boolean shuffle = false;
    boolean bulkload = false;
    Path bulkloadDir = null;
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    @Deprecated
    static long startTime_ = 0L;
    @Deprecated
    static long endTime_ = 0L;
    @Deprecated
    static int versions_ = -1;
    @Deprecated
    static String tableName_ = null;
    @Deprecated
    static String startRow_ = null;
    @Deprecated
    static String stopRow_ = null;
    @Deprecated
    static String newTableName_ = null;
    @Deprecated
    static String peerAddress_ = null;
    @Deprecated
    static String families_ = null;
    @Deprecated
    static boolean allCells_ = false;

    public CopyTable(Configuration conf) {
        super(conf);
    }

    @Deprecated
    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!CopyTable.deprecatedDoCommandLine(args)) {
            return null;
        }
        Job job = new Job(conf, "copytable_" + tableName_);
        job.setJarByClass(CopyTable.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        if (startTime_ != 0L) {
            scan.setTimeRange(startTime_, endTime_ == 0L ? Long.MAX_VALUE : endTime_);
        }
        if (allCells_) {
            scan.setRaw(true);
        }
        if (versions_ >= 0) {
            scan.setMaxVersions(versions_);
        }
        if (startRow_ != null) {
            scan.setStartRow(Bytes.toBytes((String)startRow_));
        }
        if (stopRow_ != null) {
            scan.setStopRow(Bytes.toBytes((String)stopRow_));
        }
        if (families_ != null) {
            String[] fams = families_.split(",");
            HashMap<String, String> cfRenameMap = new HashMap<String, String>();
            for (String fam : fams) {
                String sourceCf;
                if (fam.contains(":")) {
                    String[] srcAndDest = fam.split(":", 2);
                    sourceCf = srcAndDest[0];
                    String destCf = srcAndDest[1];
                    cfRenameMap.put(sourceCf, destCf);
                } else {
                    sourceCf = fam;
                }
                scan.addFamily(Bytes.toBytes((String)sourceCf));
            }
            Import.configureCfRenaming(job.getConfiguration(), cfRenameMap);
        }
        TableMapReduceUtil.initTableMapperJob(tableName_, scan, Import.Importer.class, null, null, job);
        TableMapReduceUtil.initTableReducerJob(newTableName_ == null ? tableName_ : newTableName_, null, job, null, peerAddress_, null, null);
        job.setNumReduceTasks(0);
        return job;
    }

    private static boolean deprecatedDoCommandLine(String[] args) {
        if (args.length < 1) {
            CopyTable.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    CopyTable.printUsage(null);
                    return false;
                }
                String startRowArgKey = "--startrow=";
                if (cmd.startsWith("--startrow=")) {
                    startRow_ = cmd.substring("--startrow=".length());
                    continue;
                }
                String stopRowArgKey = "--stoprow=";
                if (cmd.startsWith("--stoprow=")) {
                    stopRow_ = cmd.substring("--stoprow=".length());
                    continue;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    startTime_ = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    endTime_ = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String versionsArgKey = "--versions=";
                if (cmd.startsWith("--versions=")) {
                    versions_ = Integer.parseInt(cmd.substring("--versions=".length()));
                    continue;
                }
                String newNameArgKey = "--new.name=";
                if (cmd.startsWith("--new.name=")) {
                    newTableName_ = cmd.substring("--new.name=".length());
                    continue;
                }
                String peerAdrArgKey = "--peer.adr=";
                if (cmd.startsWith("--peer.adr=")) {
                    peerAddress_ = cmd.substring("--peer.adr=".length());
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    families_ = cmd.substring("--families=".length());
                    continue;
                }
                if (cmd.startsWith("--all.cells")) {
                    allCells_ = true;
                    continue;
                }
                if (i == args.length - 1) {
                    tableName_ = cmd;
                    continue;
                }
                CopyTable.printUsage("Invalid argument '" + cmd + "'");
                return false;
            }
            if (newTableName_ == null && peerAddress_ == null) {
                CopyTable.printUsage("At least a new table name or a peer address must be specified");
                return false;
            }
            if (endTime_ != 0L && startTime_ > endTime_) {
                CopyTable.printUsage("Invalid time range filter: starttime=" + startTime_ + " > endtime=" + endTime_);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CopyTable.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    public Job createSubmittableJob(String[] args) throws IOException {
        Job job;
        block37: {
            if (!this.doCommandLine(args)) {
                return null;
            }
            job = Job.getInstance((Configuration)this.getConf(), (String)this.getConf().get(JOB_NAME_CONF_KEY, "copytable_" + this.tableName));
            job.setJarByClass(CopyTable.class);
            Scan scan = new Scan();
            scan.setCacheBlocks(false);
            if (this.startTime != 0L) {
                scan.setTimeRange(this.startTime, this.endTime == 0L ? Long.MAX_VALUE : this.endTime);
            }
            if (this.allCells) {
                scan.setRaw(true);
            }
            if (shuffle) {
                job.getConfiguration().set("hbase.mapreduce.inputtable.shufflemaps", "true");
            }
            if (this.versions >= 0) {
                scan.setMaxVersions(this.versions);
            }
            if (this.startRow != null) {
                scan.setStartRow(Bytes.toBytes((String)this.startRow));
            }
            if (this.stopRow != null) {
                scan.setStopRow(Bytes.toBytes((String)this.stopRow));
            }
            if (this.families != null) {
                String[] fams = this.families.split(",");
                HashMap<String, String> cfRenameMap = new HashMap<String, String>();
                for (String fam : fams) {
                    String sourceCf;
                    if (fam.contains(":")) {
                        String[] srcAndDest = fam.split(":", 2);
                        sourceCf = srcAndDest[0];
                        String destCf = srcAndDest[1];
                        cfRenameMap.put(sourceCf, destCf);
                    } else {
                        sourceCf = fam;
                    }
                    scan.addFamily(Bytes.toBytes((String)sourceCf));
                }
                Import.configureCfRenaming(job.getConfiguration(), cfRenameMap);
            }
            job.setNumReduceTasks(0);
            if (this.bulkload) {
                TableMapReduceUtil.initTableMapperJob(this.tableName, scan, Import.KeyValueImporter.class, null, null, job);
                TableInputFormat.configureSplitTable(job, TableName.valueOf((String)this.dstTableName));
                FileSystem fs = FileSystem.get((Configuration)this.getConf());
                Random rand = new Random();
                Path root = new Path(fs.getWorkingDirectory(), NAME);
                fs.mkdirs(root);
                do {
                    this.bulkloadDir = new Path(root, "" + rand.nextLong());
                } while (fs.exists(this.bulkloadDir));
                System.out.println("HFiles will be stored at " + this.bulkloadDir);
                HFileOutputFormat2.setOutputPath((Job)job, (Path)this.bulkloadDir);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
                     Table htable = conn.getTable(TableName.valueOf((String)this.dstTableName));){
                    HFileOutputFormat2.configureIncrementalLoadMap(job, htable);
                    break block37;
                }
            }
            TableMapReduceUtil.initTableMapperJob(this.tableName, scan, Import.Importer.class, null, null, job);
            TableMapReduceUtil.initTableReducerJob(this.dstTableName, null, job, null, this.peerAddress, null, null);
        }
        return job;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: CopyTable [general options] [--starttime=X] [--endtime=Y] [--new.name=NEW] [--peer.adr=ADR] <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" rs.class     hbase.regionserver.class of the peer cluster");
        System.err.println("              specify if different from current cluster");
        System.err.println(" rs.impl      hbase.regionserver.impl of the peer cluster");
        System.err.println(" startrow     the start row");
        System.err.println(" stoprow      the stop row");
        System.err.println(" starttime    beginning of the time range (unixtime in millis)");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" endtime      end of the time range.  Ignored if no starttime specified.");
        System.err.println(" versions     number of cell versions to copy");
        System.err.println(" new.name     new table's name");
        System.err.println(" peer.adr     Address of the peer cluster given in the format");
        System.err.println("              hbase.zookeeer.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        System.err.println(" families     comma-separated list of families to copy");
        System.err.println("              To copy from cf1 to cf2, give sourceCfName:destCfName. ");
        System.err.println("              To keep the same name, just give \"cfName\"");
        System.err.println(" all.cells    also copy delete markers and deleted cells");
        System.err.println(" bulkload     Write input into HFiles and bulk load to the destination table");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" tablename    Name of the table to copy");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To copy 'TestTable' to a cluster that uses replication for a 1 hour window:");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.mapreduce.CopyTable --starttime=1265875194289 --endtime=1265878794289 --peer.adr=server1,server2,server3:2181:/hbase --families=myOldCf:myNewCf,cf2,cf3 TestTable ");
        System.err.println("For performance consider the following general option:\n  It is recommended that you set the following to >=100. A higher value uses more memory but\n  decreases the round trip time to the server and may increase performance.\n    -Dhbase.client.scanner.caching=100\n  The following should always be set to false, to prevent writing data twice, which may produce \n  inaccurate results.\n    -Dmapreduce.map.speculative=false");
    }

    private boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            CopyTable.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    CopyTable.printUsage(null);
                    return false;
                }
                String startRowArgKey = "--startrow=";
                if (cmd.startsWith("--startrow=")) {
                    this.startRow = cmd.substring("--startrow=".length());
                    continue;
                }
                String stopRowArgKey = "--stoprow=";
                if (cmd.startsWith("--stoprow=")) {
                    this.stopRow = cmd.substring("--stoprow=".length());
                    continue;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    this.startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    this.endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String versionsArgKey = "--versions=";
                if (cmd.startsWith("--versions=")) {
                    this.versions = Integer.parseInt(cmd.substring("--versions=".length()));
                    continue;
                }
                String newNameArgKey = "--new.name=";
                if (cmd.startsWith("--new.name=")) {
                    this.dstTableName = cmd.substring("--new.name=".length());
                    continue;
                }
                String peerAdrArgKey = "--peer.adr=";
                if (cmd.startsWith("--peer.adr=")) {
                    this.peerAddress = cmd.substring("--peer.adr=".length());
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    this.families = cmd.substring("--families=".length());
                    continue;
                }
                if (cmd.startsWith("--all.cells")) {
                    this.allCells = true;
                    continue;
                }
                if (cmd.startsWith("--bulkload")) {
                    this.bulkload = true;
                    continue;
                }
                if (cmd.startsWith("--shuffle")) {
                    shuffle = true;
                    continue;
                }
                if (i == args.length - 1) {
                    this.tableName = cmd;
                    continue;
                }
                CopyTable.printUsage("Invalid argument '" + cmd + "'");
                return false;
            }
            if (this.dstTableName == null && this.peerAddress == null) {
                CopyTable.printUsage("At least a new table name or a peer address must be specified");
                return false;
            }
            if (this.endTime != 0L && this.startTime > this.endTime) {
                CopyTable.printUsage("Invalid time range filter: starttime=" + this.startTime + " >  endtime=" + this.endTime);
                return false;
            }
            if (this.bulkload && this.peerAddress != null) {
                CopyTable.printUsage("Remote bulkload is not supported!");
                return false;
            }
            if (this.dstTableName == null) {
                this.dstTableName = this.tableName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CopyTable.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new CopyTable(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        FileSystem fs;
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        Job job = this.createSubmittableJob(otherArgs);
        if (job == null) {
            return 1;
        }
        if (!job.waitForCompletion(true)) {
            LOG.info((Object)"Map-reduce job failed!");
            if (this.bulkload) {
                LOG.info((Object)"Files are not bulkloaded!");
            }
            return 1;
        }
        int code = 0;
        if (this.bulkload && (code = new LoadIncrementalHFiles(this.getConf()).run(new String[]{this.bulkloadDir.toString(), this.dstTableName})) == 0 && !(fs = FileSystem.get((Configuration)this.getConf())).delete(this.bulkloadDir, true)) {
            LOG.error((Object)("Deleting folder " + this.bulkloadDir + " failed!"));
            code = 1;
        }
        return code;
    }
}

